/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.tx.TransactionException;

public class PlacementDriverHelper {
    private static final IgniteLogger LOG = Loggers.forClass(PlacementDriverHelper.class);
    private static final int AWAIT_PRIMARY_REPLICA_TIMEOUT = 10;
    private final PlacementDriver placementDriver;
    private final ClockService clockService;

    public PlacementDriverHelper(PlacementDriver placementDriver, ClockService clockService) {
        this.placementDriver = placementDriver;
        this.clockService = clockService;
    }

    public CompletableFuture<ReplicaMeta> awaitPrimaryReplicaWithExceptionHandling(TablePartitionId partitionId) {
        HybridTimestamp timestamp = this.clockService.now();
        return this.awaitPrimaryReplicaWithExceptionHandling(partitionId, timestamp);
    }

    private CompletableFuture<ReplicaMeta> awaitPrimaryReplicaWithExceptionHandling(TablePartitionId partitionId, HybridTimestamp timestamp) {
        return this.placementDriver.awaitPrimaryReplica((ReplicationGroupId)partitionId, timestamp, 10L, TimeUnit.SECONDS).handle((primaryReplica, e) -> {
            if (e != null) {
                LOG.debug("Failed to retrieve primary replica for partition {}", new Object[]{partitionId, e});
                throw (TransactionException)ExceptionUtils.withCause(TransactionException::new, (int)ErrorGroups.Replicator.REPLICA_UNAVAILABLE_ERR, (String)("Failed to get the primary replica [tablePartitionId=" + String.valueOf(partitionId) + ", awaitTimestamp=" + String.valueOf(timestamp) + "]"), (Throwable)e);
            }
            return primaryReplica;
        });
    }

    public CompletableFuture<PartitionData> findPrimaryReplicas(Collection<TablePartitionId> partitions) {
        return this.computePrimaryReplicas(partitions, (arg_0, arg_1) -> ((PlacementDriver)this.placementDriver).getPrimaryReplica(arg_0, arg_1));
    }

    public CompletableFuture<Map<String, Set<TablePartitionId>>> awaitPrimaryReplicas(Collection<TablePartitionId> partitions) {
        return this.computePrimaryReplicas(partitions, this::awaitPrimaryReplicaWithExceptionHandling).thenApply(partitionData -> partitionData.partitionsByNode);
    }

    private CompletableFuture<PartitionData> computePrimaryReplicas(Collection<TablePartitionId> partitions, BiFunction<TablePartitionId, HybridTimestamp, CompletableFuture<ReplicaMeta>> placementFunction) {
        if (partitions == null || partitions.isEmpty()) {
            return CompletableFuture.completedFuture(new PartitionData(Collections.emptyMap(), Collections.emptySet()));
        }
        HybridTimestamp timestamp = this.clockService.now();
        HashMap<TablePartitionId, CompletableFuture<ReplicaMeta>> primaryReplicaFutures = new HashMap<TablePartitionId, CompletableFuture<ReplicaMeta>>();
        for (TablePartitionId partitionId : partitions) {
            primaryReplicaFutures.put(partitionId, placementFunction.apply(partitionId, timestamp));
        }
        return CompletableFuture.allOf(primaryReplicaFutures.values().toArray(new CompletableFuture[0])).thenApply(v -> {
            HashMap<String, Set<TablePartitionId>> partitionsByNode = new HashMap<String, Set<TablePartitionId>>();
            HashSet<TablePartitionId> partitionsWithoutPrimary = new HashSet<TablePartitionId>();
            for (Map.Entry entry : primaryReplicaFutures.entrySet()) {
                ReplicaMeta meta = (ReplicaMeta)((CompletableFuture)entry.getValue()).join();
                TablePartitionId partition = (TablePartitionId)entry.getKey();
                if (meta != null && meta.getLeaseholder() != null) {
                    partitionsByNode.computeIfAbsent(meta.getLeaseholder(), s -> new HashSet()).add(partition);
                    continue;
                }
                partitionsWithoutPrimary.add(partition);
            }
            return new PartitionData(partitionsByNode, partitionsWithoutPrimary);
        });
    }

    public static class PartitionData {
        final Map<String, Set<TablePartitionId>> partitionsByNode;
        final Set<TablePartitionId> partitionsWithoutPrimary;

        PartitionData(Map<String, Set<TablePartitionId>> partitionsByNode, Set<TablePartitionId> partitionsWithoutPrimary) {
            this.partitionsByNode = partitionsByNode;
            this.partitionsWithoutPrimary = partitionsWithoutPrimary;
        }
    }
}

