/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.internal.configuration.RootInnerNode;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.jetbrains.annotations.Nullable;

public final class SuperRoot
extends InnerNode {
    private final SortedMap<String, RootInnerNode> roots = new TreeMap<String, RootInnerNode>();
    private final Function<String, RootInnerNode> nodeCreator;

    private SuperRoot(SuperRoot superRoot) {
        this.roots.putAll(superRoot.roots);
        this.nodeCreator = superRoot.nodeCreator;
    }

    public SuperRoot(Function<String, RootInnerNode> nodeCreator) {
        this(nodeCreator, Map.of());
    }

    public SuperRoot(Function<String, RootInnerNode> nodeCreator, Map<RootKey<?, ?>, InnerNode> roots) {
        this.nodeCreator = nodeCreator;
        for (Map.Entry<RootKey<?, ?>, InnerNode> entry : roots.entrySet()) {
            this.roots.put(entry.getKey().key(), new RootInnerNode(entry.getKey(), entry.getValue().copy()));
        }
    }

    public void addRoot(RootKey<?, ?> rootKey, InnerNode root) {
        assert (!this.roots.containsKey(rootKey.key())) : rootKey.key() + " : " + String.valueOf(this.roots);
        this.assertMutability();
        this.roots.put(rootKey.key(), new RootInnerNode(rootKey, root));
    }

    @Nullable
    public InnerNode getRoot(RootKey<?, ?> rootKey) {
        RootInnerNode root = (RootInnerNode)this.roots.get(rootKey.key());
        return root == null ? null : root.node();
    }

    @Override
    public <T> void traverseChildren(ConfigurationVisitor<T> visitor, boolean includeInternal) {
        for (Map.Entry<String, RootInnerNode> e : this.roots.entrySet()) {
            if (!includeInternal && e.getValue().internal()) continue;
            visitor.visitInnerNode(null, e.getKey(), e.getValue().node());
        }
    }

    @Override
    public <T> T traverseChild(String key, ConfigurationVisitor<T> visitor, boolean includeInternal) throws NoSuchElementException {
        RootInnerNode root = (RootInnerNode)this.roots.get(key);
        if (root == null || !includeInternal && root.internal()) {
            throw new NoSuchElementException(key);
        }
        return visitor.visitInnerNode(null, key, root.node());
    }

    @Override
    public void construct(String key, ConfigurationSource src, boolean includeInternal) throws NoSuchElementException {
        this.assertMutability();
        RootInnerNode root = (RootInnerNode)this.roots.get(key);
        if (root == null) {
            root = this.nodeCreator.apply(key);
        }
        if (root == null || !includeInternal && root.internal()) {
            throw new NoSuchElementException(key);
        }
        if (src == null) {
            this.roots.remove(key);
        } else {
            root = new RootInnerNode(root);
            this.roots.put(key, root);
            src.descend(root.node());
        }
    }

    @Override
    public void constructDefault(String key) throws NoSuchElementException {
        throw new NoSuchElementException(key);
    }

    @Override
    public Class<?> schemaType() {
        return Object.class;
    }

    @Override
    public SuperRoot copy() {
        return new SuperRoot(this);
    }
}

