/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.gossip;

import io.scalecube.cluster.gossip.Gossip;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

final class GossipState {
    private final Gossip gossip;
    private final long infectionPeriod;
    private final Set<String> infected = new HashSet<String>();

    GossipState(Gossip gossip, long infectionPeriod) {
        this.gossip = Objects.requireNonNull(gossip);
        this.infectionPeriod = infectionPeriod;
    }

    public Gossip gossip() {
        return this.gossip;
    }

    public long infectionPeriod() {
        return this.infectionPeriod;
    }

    public void addToInfected(String memberId) {
        this.infected.add(memberId);
    }

    public boolean isInfected(String memberId) {
        return this.infected.contains(memberId);
    }

    public String toString() {
        return new StringJoiner(", ", GossipState.class.getSimpleName() + "[", "]").add("gossip=" + this.gossip).add("infectionPeriod=" + this.infectionPeriod).add("infected=" + this.infected).toString();
    }
}

