/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.raft.handlers;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.partition.replicator.raft.handlers.AbstractCommandHandler;
import org.jetbrains.annotations.Nullable;

public class CommandHandlers {
    private final Map<MessageId, AbstractCommandHandler<?>> handlers;

    private CommandHandlers(Map<MessageId, AbstractCommandHandler<?>> handlers) {
        this.handlers = handlers;
    }

    @Nullable
    public AbstractCommandHandler<?> handler(short messageGroup, short messageType) {
        return this.handlers.get(new MessageId(messageGroup, messageType));
    }

    private static final class MessageId {
        final short messageGroup;
        final short messageType;

        MessageId(short messageGroup, short messageType) {
            this.messageGroup = messageGroup;
            this.messageType = messageType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessageId messageId = (MessageId)o;
            return this.messageGroup == messageId.messageGroup && this.messageType == messageId.messageType;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.messageGroup;
            result = 31 * result + this.messageType;
            return result;
        }
    }

    public static class Builder {
        private final Map<MessageId, AbstractCommandHandler<?>> handlers = new HashMap();

        public Builder addHandler(short messageGroup, short messageType, AbstractCommandHandler<?> handler) throws IllegalArgumentException {
            MessageId id = new MessageId(messageGroup, messageType);
            if (this.handlers.containsKey(id)) {
                throw new IllegalArgumentException("Handler already exists [messageGroup=" + messageGroup + ", messageType=" + messageType + "].");
            }
            this.handlers.put(id, handler);
            return this;
        }

        public CommandHandlers build() {
            return new CommandHandlers(this.handlers);
        }
    }
}

