/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.rules.ImmutableAggregateMinMaxToLimitRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class AggregateMinMaxToLimitRule
extends RelRule<Config>
implements TransformationRule {
    protected AggregateMinMaxToLimitRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Aggregate agg = (Aggregate)call.rel(0);
        if (!agg.getGroupSet().isEmpty()) {
            return false;
        }
        return agg.getAggCallList().stream().allMatch(aggCall -> aggCall.getAggregation().getKind() == SqlKind.MIN || aggCall.getAggregation().getKind() == SqlKind.MAX);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate agg = (Aggregate)call.rel(0);
        RelNode aggInput = agg.getInput().stripped();
        RelBuilder builder = call.builder();
        builder.push(aggInput);
        ArrayList<RexSubQuery> newProjects = new ArrayList<RexSubQuery>();
        for (AggregateCall aggCall : agg.getAggCallList()) {
            int idx = aggCall.getArgList().get(0);
            RexInputRef r = builder.field(idx);
            if (!RexUtil.isDeterministic(r)) {
                return;
            }
            boolean isDesc = aggCall.getAggregation().kind == SqlKind.MAX;
            RexSubQuery subQuery = builder.scalarQuery(b -> b.push(aggInput).project(r).filter(b.isNotNull(r)).sortLimit(0, 1, isDesc ? builder.desc(r) : r).build());
            newProjects.add(subQuery);
        }
        builder.clear();
        builder.values(new String[]{"i"}, 1).project(newProjects);
        call.transformTo(builder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableAggregateMinMaxToLimitRule.Config.of().withOperandFor(Aggregate.class);

        @Override
        default public AggregateMinMaxToLimitRule toRule() {
            return new AggregateMinMaxToLimitRule(this);
        }

        default public Config withOperandFor(Class<? extends Aggregate> aggregateClass) {
            return this.withOperandSupplier(b0 -> b0.operand(aggregateClass).anyInputs()).as(Config.class);
        }
    }
}

