/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.FieldInstruction;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

class GetFieldBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final ParameterizedType declaringClass;
    private final String name;

    GetFieldBytecodeExpression(@Nullable BytecodeExpression instance, Class<?> declaringClass, String name) {
        this(instance, GetFieldBytecodeExpression.getDeclaredField(declaringClass, name));
    }

    GetFieldBytecodeExpression(@Nullable BytecodeExpression instance, Field field) {
        this(instance, ParameterizedType.type(Objects.requireNonNull(field, "field is null").getDeclaringClass()), field.getName(), ParameterizedType.type(field.getType()));
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        if (instance == null) {
            BytecodeUtils.checkArgument(isStatic, "Field is not static: %s", field);
        } else {
            BytecodeUtils.checkArgument(!isStatic, "Field is static: %s", field);
        }
    }

    GetFieldBytecodeExpression(@Nullable BytecodeExpression instance, FieldDefinition field) {
        this(instance, Objects.requireNonNull(field, "field is null").getDeclaringClass().getType(), field.getName(), field.getType());
        if (instance == null) {
            BytecodeUtils.checkArgument(field.getAccess().contains((Object)Access.STATIC), "Field is not static: %s", field);
        } else {
            BytecodeUtils.checkArgument(!field.getAccess().contains((Object)Access.STATIC), "Field is static: %s", field);
        }
    }

    GetFieldBytecodeExpression(@Nullable BytecodeExpression instance, ParameterizedType declaringClass, String name, ParameterizedType type) {
        super(type);
        BytecodeUtils.checkArgument(instance == null || !instance.getType().isPrimitive(), "Type %s does not have fields", this.getType());
        this.instance = instance;
        this.declaringClass = Objects.requireNonNull(declaringClass, "declaringClass is null");
        this.name = Objects.requireNonNull(name, "name is null");
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        if (this.instance == null) {
            return FieldInstruction.getStaticInstruction(this.declaringClass, this.name, this.getType());
        }
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).getField(this.declaringClass, this.name, this.getType());
    }

    @Override
    protected String formatOneLine() {
        if (this.instance == null) {
            return this.declaringClass.getSimpleName() + "." + this.name;
        }
        return String.valueOf(this.instance) + "." + this.name;
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return this.instance == null ? List.of() : List.of(this.instance);
    }

    private static Field getDeclaredField(Class<?> declaringClass, String name) {
        Objects.requireNonNull(declaringClass, "declaringClass is null");
        Objects.requireNonNull(name, "name is null");
        try {
            return declaringClass.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("Class %s does not have a '%s' field", declaringClass.getName(), name));
        }
    }
}

