/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.compute;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ClientContext;
import org.apache.ignite.client.handler.NotificationSender;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.client.handler.requests.compute.ClientComputeExecuteRequest;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.ProtocolBitmaskFeature;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.apache.ignite.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.table.IgniteTables;

public class ClientComputeExecutePartitionedRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteComputeInternal compute, IgniteTables tables, ClusterService cluster, NotificationSender notificationSender, ClientContext clientContext) {
        int tableId = in.unpackInt();
        int partitionId = in.unpackInt();
        ClientComputeJobUnpacker.Job job = ClientComputeJobUnpacker.unpackJob((ClientMessageUnpacker)in, (boolean)clientContext.hasFeature(ProtocolBitmaskFeature.PLATFORM_COMPUTE_JOB));
        UUID taskId = ClientComputeJobUnpacker.unpackTaskId((ClientMessageUnpacker)in, (boolean)clientContext.hasFeature(ProtocolBitmaskFeature.COMPUTE_TASK_ID));
        return ClientTableCommon.readTableAsync(tableId, tables).thenCompose(table -> {
            ComputeEventMetadataBuilder metadataBuilder = ComputeEventMetadata.builder((ComputeEventMetadata.Type)ComputeEventMetadata.Type.BROADCAST).eventUser(clientContext.userDetails()).taskId(taskId).tableName(table.name()).clientAddress(clientContext.remoteAddress().toString());
            CompletableFuture jobExecutionFut = compute.submitPartitionedInternal(table, partitionId, job.deploymentUnits(), job.jobClassName(), job.options(), metadataBuilder, job.arg(), null);
            ClientComputeExecuteRequest.sendResultAndState(jobExecutionFut, notificationSender);
            return jobExecutionFut.thenCompose(execution -> execution.idAsync().thenApply(jobId -> out -> {
                out.packInt(table.schemaView().lastKnownSchemaVersion());
                ClientComputeExecuteRequest.packSubmitResult(out, jobId, execution.node());
            }));
        });
    }
}

