@rem Licensed to the Apache Software Foundation (ASF) under one or more
@rem contributor license agreements. See the NOTICE file distributed with
@rem this work for additional information regarding copyright ownership.
@rem The ASF licenses this file to You under the Apache License, Version 2.0
@rem (the "License"); you may not use this file except in compliance with
@rem the License. You may obtain a copy of the License at
@rem
@rem      http://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

set COMMON_JAVA_OPTS=--add-opens=java.base/java.lang=ALL-UNNAMED --add-opens=java.base/java.lang.invoke=ALL-UNNAMED --add-opens=java.base/java.lang.reflect=ALL-UNNAMED --add-opens=java.base/java.io=ALL-UNNAMED --add-opens=java.base/java.nio=ALL-UNNAMED --add-opens=java.base/java.math=ALL-UNNAMED --add-opens=java.base/java.util=ALL-UNNAMED --add-opens=java.base/java.time=ALL-UNNAMED --add-opens=java.base/jdk.internal.misc=ALL-UNNAMED --add-opens=java.base/jdk.internal.access=ALL-UNNAMED --add-opens=java.base/sun.nio.ch=ALL-UNNAMED --add-opens=java.base/sun.security.x509=ALL-UNNAMED ^
-Dio.netty.tryReflectionSetAccessible=true ^
-Dfile.encoding=UTF-8 ^
-XX:+HeapDumpOnOutOfMemoryError ^
-XX:+ExitOnOutOfMemoryError

set LOGGING_JAVA_OPTS=-Djava.util.logging.config.file="%CONF_DIR%\ignite.java.util.logging.properties" ^
-XX:HeapDumpPath="%LOG_DIR%" ^
-Xlog:gc=info:file="%LOG_DIR%\%JVM_GC_LOG_NAME%"::filecount=%JVM_GC_NUM_LOGS%,filesize=%JVM_GC_LOG_SIZE%

set CLASSPATH=-classpath "%LIBS_DIR%\*" org.apache.ignite.internal.app.IgniteRunner

set JAVA_MEMORY_OPTIONS=-Xmx%JVM_MAX_MEM% -Xms%JVM_MIN_MEM%

set JAVA_GC_OPTIONS=-XX:+Use%JVM_GC% -XX:G1HeapRegionSize=%JVM_G1HeapRegionSize%

set JAVA_CMD_WITH_ARGS="%JAVA_EXE%" ^
%COMMON_JAVA_OPTS% ^
%LOGGING_JAVA_OPTS% ^
%JAVA_MEMORY_OPTIONS% ^
%JAVA_GC_OPTIONS% ^
%IGNITE3_EXTRA_JVM_ARGS% ^
%CLASSPATH%

set APPLICATION_ARGS=--config-path "%CONFIG_FILE%" --work-dir "%WORK_DIR%" --node-name %NODE_NAME%
