/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.treesitter.parser;

import org.treesitter.TSNode;

public enum JsonTokenType {
    QUOTE,
    STRING_CONTENT,
    VALUE_STRING,
    NUMBER,
    LEFT_BRACKET,
    RIGHT_BRACKET,
    COLON,
    BRACKET,
    COMMA,
    UNKNOWN,
    BOOL,
    SPACE;


    static JsonTokenType fromNode(TSNode node) {
        switch (node.getType()) {
            case "\"": {
                return QUOTE;
            }
            case "string_content": {
                return STRING_CONTENT;
            }
            case "{": 
            case "}": 
            case "[": 
            case "]": {
                return BRACKET;
            }
            case ",": {
                return COMMA;
            }
            case ":": {
                return COLON;
            }
            case "number": {
                return NUMBER;
            }
            case "true": 
            case "false": {
                return BOOL;
            }
        }
        return UNKNOWN;
    }
}

