/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.jdbc.proto.event;

import java.util.Objects;
import org.apache.ignite3.internal.client.proto.ClientMessagePacker;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.jdbc.proto.event.Response;
import org.apache.ignite3.internal.tostring.S;

public class JdbcTableMeta
extends Response {
    private String schemaName;
    private String tblName;
    private String tblType;

    public JdbcTableMeta() {
    }

    public JdbcTableMeta(String schemaName, String tblName, String tblType) {
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.tblType = tblType;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String tableType() {
        return this.tblType;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.success()) {
            return;
        }
        packer.packString(this.schemaName);
        packer.packString(this.tblName);
        packer.packString(this.tblType);
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.success()) {
            return;
        }
        this.schemaName = unpacker.unpackString();
        this.tblName = unpacker.unpackString();
        this.tblType = unpacker.unpackString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcTableMeta meta = (JdbcTableMeta)o;
        return Objects.equals(this.schemaName, meta.schemaName) && Objects.equals(this.tblName, meta.tblName) && Objects.equals(this.tblType, meta.tblType);
    }

    public int hashCode() {
        int result = this.schemaName.hashCode();
        result = 31 * result + this.tblName.hashCode();
        result = 31 * result + this.tblType.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return S.toString(JdbcTableMeta.class, this);
    }
}

