/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.lang.AsyncCursor;

public class AntiHijackAsyncCursor<T>
implements AsyncCursor<T> {
    private final AsyncCursor<T> cursor;
    private final Executor asyncContinuationExecutor;

    public AntiHijackAsyncCursor(AsyncCursor<T> cursor, Executor asyncContinuationExecutor) {
        this.cursor = cursor;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public Iterable<T> currentPage() {
        return this.cursor.currentPage();
    }

    @Override
    public int currentPageSize() {
        return this.cursor.currentPageSize();
    }

    @Override
    public CompletableFuture<? extends AsyncCursor<T>> fetchNextPage() {
        return PublicApiThreading.preventThreadHijack(this.cursor.fetchNextPage(), this.asyncContinuationExecutor).thenApply(nextCursor -> new AntiHijackAsyncCursor<T>(nextCursor, this.asyncContinuationExecutor));
    }

    @Override
    public boolean hasMorePages() {
        return this.cursor.hasMorePages();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return PublicApiThreading.preventThreadHijack(this.cursor.closeAsync(), this.asyncContinuationExecutor);
    }
}

