/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.config.registry;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.migrationtools.config.registry.ConfigurationRegistryInterface;
import org.apache.ignite3.configuration.ConfigurationTree;
import org.apache.ignite3.configuration.RootKey;
import org.apache.ignite3.internal.configuration.ConfigurationRegistry;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.util.IgniteUtils;

public class CombinedConfigRegistry
implements ConfigurationRegistryInterface {
    private final ConfigurationRegistry localRegistry;
    private final ConfigurationRegistry distributedRegistry;

    public CombinedConfigRegistry(ConfigurationRegistry localRegistry, ConfigurationRegistry distributedRegistry) {
        this.localRegistry = localRegistry;
        this.distributedRegistry = distributedRegistry;
    }

    public CompletableFuture<Void> startAsync(ComponentContext context) {
        return IgniteUtils.startAsync((ComponentContext)context, (IgniteComponent[])new IgniteComponent[]{this.localRegistry, this.distributedRegistry});
    }

    public CompletableFuture<Void> stopAsync(ComponentContext context) {
        return IgniteUtils.stopAsync((ComponentContext)context, (IgniteComponent[])new IgniteComponent[]{this.localRegistry, this.distributedRegistry});
    }

    @Override
    public <V, C extends V, T extends ConfigurationTree<? super V, ? super C>> T getConfiguration(RootKey<T, V, C> rootKey) {
        return (T)Optional.ofNullable(this.localRegistry.getConfiguration(rootKey)).orElseGet(() -> this.distributedRegistry.getConfiguration(rootKey));
    }

    public CompletableFuture<Void> onDefaultsPersisted() {
        return CompletableFuture.allOf(this.localRegistry.onDefaultsPersisted(), this.distributedRegistry.onDefaultsPersisted());
    }
}

