/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.resource;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.lang.IgniteClosure;

final class GridResourceUtils {
    private GridResourceUtils() {
    }

    static void inject(Field field, Object target, Object rsrc) throws IgniteCheckedException {
        if (rsrc != null && !field.getType().isAssignableFrom(rsrc.getClass())) {
            throw new IgniteCheckedException("Resource field is not assignable from the resource: " + rsrc.getClass());
        }
        try {
            field.setAccessible(true);
            field.set(target, rsrc);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | SecurityException e) {
            throw new IgniteCheckedException("Failed to inject resource [field=" + field.getName() + ", target=" + target + ", rsrc=" + rsrc + ']', e);
        }
    }

    static void inject(Method mtd, Object target, Object rsrc) throws IgniteCheckedException {
        if (mtd.getParameterTypes().length != 1 || rsrc != null && !mtd.getParameterTypes()[0].isAssignableFrom(rsrc.getClass())) {
            throw new IgniteCheckedException("Setter does not have single parameter of required type [type=" + rsrc.getClass().getName() + ", setter=" + mtd + ']');
        }
        try {
            mtd.setAccessible(true);
            mtd.invoke(target, rsrc);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InvocationTargetException e) {
            throw new IgniteCheckedException("Failed to inject resource [method=" + mtd.getName() + ", target=" + target + ", rsrc=" + rsrc + ']', e);
        }
    }

    static boolean mayRequireResources(Field f) {
        assert (f != null);
        return f.getName().startsWith("this$") || f.getName().startsWith("val$") || Callable.class.isAssignableFrom(f.getType()) || Runnable.class.isAssignableFrom(f.getType()) || IgniteClosure.class.isAssignableFrom(f.getType());
    }
}

