/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorClientConnectorConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String host;
    private int port;
    private int portRange;
    private int maxOpenCursorsPerConn;
    private int sockSndBufSize;
    private int sockRcvBufSize;
    private boolean tcpNoDelay;
    private int threadPoolSize;
    private long idleTimeout;
    private boolean jdbcEnabled;
    private boolean odbcEnabled;
    private boolean thinCliEnabled;
    private boolean sslEnabled;
    private boolean useIgniteSslCtxFactory;
    private boolean sslClientAuth;
    private String sslCtxFactory;

    public VisorClientConnectorConfiguration() {
    }

    public VisorClientConnectorConfiguration(ClientConnectorConfiguration cfg) {
        this.host = cfg.getHost();
        this.port = cfg.getPort();
        this.portRange = cfg.getPortRange();
        this.maxOpenCursorsPerConn = cfg.getMaxOpenCursorsPerConnection();
        this.sockSndBufSize = cfg.getSocketSendBufferSize();
        this.sockRcvBufSize = cfg.getSocketReceiveBufferSize();
        this.tcpNoDelay = cfg.isTcpNoDelay();
        this.threadPoolSize = cfg.getThreadPoolSize();
        this.idleTimeout = cfg.getIdleTimeout();
        this.jdbcEnabled = cfg.isJdbcEnabled();
        this.odbcEnabled = cfg.isOdbcEnabled();
        this.thinCliEnabled = cfg.isThinClientEnabled();
        this.sslEnabled = cfg.isSslEnabled();
        this.useIgniteSslCtxFactory = cfg.isUseIgniteSslContextFactory();
        this.sslClientAuth = cfg.isSslClientAuth();
        this.sslCtxFactory = VisorTaskUtils.compactClass(cfg.getSslContextFactory());
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getPortRange() {
        return this.portRange;
    }

    public int getMaxOpenCursorsPerConnection() {
        return this.maxOpenCursorsPerConn;
    }

    public int getSocketSendBufferSize() {
        return this.sockSndBufSize;
    }

    public int getSocketReceiveBufferSize() {
        return this.sockRcvBufSize;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public boolean isJdbcEnabled() {
        return this.jdbcEnabled;
    }

    public boolean isOdbcEnabled() {
        return this.odbcEnabled;
    }

    public boolean isThinClientEnabled() {
        return this.thinCliEnabled;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public boolean isUseIgniteSslContextFactory() {
        return this.useIgniteSslCtxFactory;
    }

    public boolean isSslClientAuth() {
        return this.sslClientAuth;
    }

    public String getSslContextFactory() {
        return this.sslCtxFactory;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.host);
        out.writeInt(this.port);
        out.writeInt(this.portRange);
        out.writeInt(this.maxOpenCursorsPerConn);
        out.writeInt(this.sockSndBufSize);
        out.writeInt(this.sockRcvBufSize);
        out.writeBoolean(this.tcpNoDelay);
        out.writeInt(this.threadPoolSize);
        out.writeLong(this.idleTimeout);
        out.writeBoolean(this.jdbcEnabled);
        out.writeBoolean(this.odbcEnabled);
        out.writeBoolean(this.thinCliEnabled);
        out.writeBoolean(this.sslEnabled);
        out.writeBoolean(this.useIgniteSslCtxFactory);
        out.writeBoolean(this.sslClientAuth);
        U.writeString(out, this.sslCtxFactory);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.host = U.readString(in);
        this.port = in.readInt();
        this.portRange = in.readInt();
        this.maxOpenCursorsPerConn = in.readInt();
        this.sockSndBufSize = in.readInt();
        this.sockRcvBufSize = in.readInt();
        this.tcpNoDelay = in.readBoolean();
        this.threadPoolSize = in.readInt();
        if (protoVer > 1) {
            this.idleTimeout = in.readLong();
            this.jdbcEnabled = in.readBoolean();
            this.odbcEnabled = in.readBoolean();
            this.thinCliEnabled = in.readBoolean();
            this.sslEnabled = in.readBoolean();
            this.useIgniteSslCtxFactory = in.readBoolean();
            this.sslClientAuth = in.readBoolean();
            this.sslCtxFactory = U.readString(in);
        }
    }

    public String toString() {
        return S.toString(VisorClientConnectorConfiguration.class, this);
    }
}

