<!--
   Licensed to the Apache Software Foundation (ASF) under one
   or more contributor license agreements.  See the NOTICE file
   distributed with this work for additional information
   regarding copyright ownership.  The ASF licenses this file
   to you under the Apache License, Version 2.0 (the
   "License"); you may not use this file except in compliance
   with the License.  You may obtain a copy of the License at
     http://www.apache.org/licenses/LICENSE-2.0
   Unless required by applicable law or agreed to in writing,
   software distributed under the License is distributed on an
   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
   KIND, either express or implied.  See the License for the
   specific language governing permissions and limitations
   under the License.
-->

# 0.32.0 (alpha)

- NO-ISSUE - Add DMN 1.5 specification files to `packages/dmn-marshaller`
- [kie-issues#180](https://github.com/apache/incubator-kie-issues/issues/180) - On DMN Editor's Boxed Expression Editor, when resizing Context/Invocation entry info cells, minWidths are getting messy
- [kie-issues#510](https://github.com/apache/incubator-kie-issues/issues/510) - Content assist in DMN Editor doesn't allow true/false without major changes
- [kie-issues#420](https://github.com/apache/incubator-kie-issues/issues/420) - Boxed expression component context menu renders both selected and the chosen cell menu
- [kie-issues#159](https://github.com/apache/incubator-kie-issues/issues/159) - Colorize variable names in FEEL inputs on DMN Editor's Boxed Expression Editor
- [kie-issues#589](https://github.com/apache/incubator-kie-issues/issues/589) - Monaco-editor doesn't apply colorisation in DMN Editor
- [kie-issues#590](https://github.com/apache/incubator-kie-issues/issues/590) - In Boxed Expression Editor, Insert N columns/rows does nothing

# 0.31.0 (alpha)

- [kie-issues#183](https://github.com/apache/incubator-kie-issues/issues/183) - Dead keys (E.g., ˜ˆ´¨) are not triggering edit mode correctly on BeeTable cells
- [kie-issues#184](https://github.com/apache/incubator-kie-issues/issues/184) - It shouldn't be possible to mutate the selection when selecting text inside a BeeTable cell
- [kie-issues#216](https://github.com/apache/incubator-kie-issues/issues/216) - DMN's Editor Boxed Expression Editor: It's not possible to delete a table row in Safari
- [kie-issues#48](https://github.com/apache/incubator-kie-issues/issues/48) - Implement DMN 1.3 new keywords support
- [kie-issues#168](https://github.com/apache/incubator-kie-issues/issues/168) - In DMN Editor's Boxed Expression Editor Context Menu, make possible to add N rows/columns with a single click
- [kie-issues#365](https://github.com/apache/incubator-kie-issues/issues/365) - Top-left cell data is getting lost after Cutting and Pasting to the DMN Editor's Boxed Expression Editor
- [kie-issues#372](https://github.com/apache/incubator-kie-issues/issues/372) - DMN Editor: Removing GWT-based autocompletion feature
- [kie-issues#353](https://github.com/apache/incubator-kie-issues/issues/353) - DMN Editor Add documentation to every FEEL function proposed by code completion
- [kie-issues#373](https://github.com/apache/incubator-kie-issues/issues/373) - DMN's Decision Table: Changing the column data type doens't work after changing Decision node type
- [kie-issues#375](https://github.com/apache/incubator-kie-issues/issues/375) - DMN Editor: Context Menu is empty in List expression header
- [kie-issues#376](https://github.com/apache/incubator-kie-issues/issues/376) - DMN Runner context menu options are not appropriate regarding the selected cell
- [kie-issues#382](https://github.com/apache/incubator-kie-issues/issues/382) - [DMN Editor] Superfluous newline in multi-cell copy/paste

# 0.30.0 (alpha)

- [kie-issues#252](https://github.com/apache/incubator-kie-issues/issues/252) - A Decision Table's single output column header should be merged
- [kie-issues#288](https://github.com/apache/incubator-kie-issues/issues/288) - [DMN Editor] the dmn:literalExpression id must not be modified on editing some text
- [kie-issues#282](https://github.com/apache/incubator-kie-issues/issues/282) - [DMN Editor] Default output value disappears
- [kie-issues#287](https://github.com/apache/incubator-kie-issues/issues/287) - After deleting a Decision Table row, cells are wrongly selected
- [kie-issues#114](https://github.com/apache/incubator-kie-issues/issues/114) - Temporarily disable `fetch classes` functionality of Import Java Classes
- [kie-issues#289](https://github.com/apache/incubator-kie-issues/issues/289) - Remove @KieActivator annotation used in Import Java Classes
- [kie-issues#272](https://github.com/apache/incubator-kie-issues/issues/272) - Context Menu should always choose the best strategy to render, based on the available space of its container element
- [kie-issues#312](https://github.com/apache/incubator-kie-issues/issues/312) - kie-tools#1666 breaks the DMN Editor for all DMNs that relies on JSON schema draft 4 to generate the DMN Runner table and form
- [kie-issues#309](https://github.com/apache/incubator-kie-issues/issues/309) - User is not able to specify DMN Range constraint for `date and time` and `years and months duration` custom type
- [kie-issues#318](https://github.com/apache/incubator-kie-issues/issues/318) - Data Type for Invocation and Decision Table merged output columns is not updated
- [kie-issues#319](https://github.com/apache/incubator-kie-issues/issues/319) - On the DMN Editor, Expression properties are not correctly persisted
- [kie-issues#326](https://github.com/apache/incubator-kie-issues/issues/326) - DMN Editor's Properties Panel changing element selection when blurring out of changed inputs
- [kie-issues#259](https://github.com/apache/incubator-kie-issues/issues/259) - Make DMN Editor's Boxed Expression Editor Context Menu show only relevant operations for specific cells.
- [kie-issues#344](https://github.com/apache/incubator-kie-issues/issues/344) - DMN Editor: Name and Data type popover menu visual misalignments in form labels
- [kie-issues#347](https://github.com/apache/incubator-kie-issues/issues/347) - DMN Editor: Duplicate is not working for a relation
- [kie-issues#345](https://github.com/apache/incubator-kie-issues/issues/345) - DMN Editor: Sort function is missing in autocompletions
- [kie-issues#348](https://github.com/apache/incubator-kie-issues/issues/348) - DMN Editor: Function header context menus are empty

# 0.29.0 (alpha)

- [kie-issues#113](https://github.com/apache/incubator-kie-issues/issues/113) - Remove unnecessary rendering calls to DMN Editor's Boxed Expression Editor
- [kie-issues#163](https://github.com/apache/incubator-kie-issues/issues/163) - In DMN Editor's Boxed Expression Editor, long names are not being truncated in DecisionTable sub-headers and in the name of root expressions
- [kie-issues#255](https://github.com/apache/incubator-kie-issues/issues/255) - A Not-collect Hit Policy should clear aggregation type
- [kie-issues#250](https://github.com/apache/incubator-kie-issues/issues/250) - Width changes are not correctly persisted
- [kie-issues#258](https://github.com/apache/incubator-kie-issues/issues/258) - Use data type current value when opening DMN constraint modal
- [kie-issues#222](https://github.com/apache/incubator-kie-issues/issues/222) - When editing a BeeTable cell with selected text, the selection is lost when mouse hovers in or out of it
- [kie-issues#210](https://github.com/apache/incubator-kie-issues/issues/210) - Keyboard shortcuts stop working after blurring out of some components on the BeeTable
- [kie-issues#114](https://github.com/apache/incubator-kie-issues/issues/114) - Part 2: Temporary comment code no more supported by API
- [kie-issues#278](https://github.com/apache/incubator-kie-issues/issues/278) - Duplicate row should not copy the inputEntry id of that row
- [kie-issues#214](https://github.com/apache/incubator-kie-issues/issues/214) - Saving a file using keyboard shortcuts (Ctrl + S) on VS Code is not working if DMN Editor's Boxed Expression Editor is focused

# 0.28.1 (alpha)

- [KOGITO-9105](https://issues.redhat.com/browse/KOGITO-9105) - Add KIE prefix to `displayName` of new VS Code extensions

# 0.28.0 (alpha)

- [kie-issues#42](https://github.com/apache/incubator-kie-issues/issues/42) - DMN Editor: Repetitive opening of properties panel for List expression by @danielzhe in https://github.com/apache/incubator-kie-tools/pull/1502
- [kie-issues#44](https://github.com/apache/incubator-kie-issues/issues/44) - DMN Editor: Autolayout is broken for decision services by @danielzhe in https://github.com/apache/incubator-kie-tools/pull/1495
- [kie-issues#110](https://github.com/apache/incubator-kie-issues/issues/110) - Removing \"Supported by Red Hat\" logo in DMN Editor Documentation Tab by @yesamer in https://github.com/apache/incubator-kie-tools/pull/1561
- [kie-issues#87](https://github.com/apache/incubator-kie-issues/issues/87) - Refactor the React-based Boxed Expression Component to be able to delete the GWT-based one by @tiagobento in https://github.com/apache/incubator-kie-tools/pull/1562
- [kie-issues#112](https://github.com/apache/incubator-kie-issues/issues/112) - DMN Editor - JavaAutocompletion module is not compatible with Java Languages Extension >= `1.17.0` by @yesamer in https://github.com/apache/incubator-kie-tools/pull/1591

# 0.26.0 (alpha)

- [KOGITO-8119](https://issues.redhat.com/browse/KOGITO-8119) - [DMN Editor] Import Java classes thrown an exception in Windows
- [DROOLS-3703](https://issues.redhat.com/browse/DROOLS-3703) - Disable Enumeration and Range constraint for Any DataType
- [kie-issues#28](https://github.com/apache/incubator-kie-issues/issues/28) - DMN Editor - Three undos are required to remove a newly added node
- [kie-issues#6](https://github.com/apache/incubator-kie-issues/issues/6) - Bump `gwt` version to `2.10.0` version in `stunner-editors` module
- [kie-issues#46](https://github.com/apache/incubator-kie-issues/issues/46) - Disable OK button properly in DMN Data Type Constraint modal
- [KOGITO-6974](https://issues.redhat.com/browse/KOGITO-6974) - Stunner Editors - Line control points are enabled in view only mode, but they should not

# 0.25.0 (alpha)

- [KOGITO-8077](https://issues.redhat.com/browse/KOGITO-8077) - Apache KIE Tools Security updates (3rd round)

# 0.24.0 (alpha)

- _(No new features)_

# 0.23.0 (alpha)

- [KOGITO-7797](https://issues.redhat.com/browse/KOGITO-7797) - [DMN Designer] Improving \"Import Java Classes\" button's tooltip message

# 0.22.0 (alpha)

- _(No new features)_

# 0.21.0 (alpha)

- [KOGITO-7375](https://issues.redhat.com/browse/KOGITO-7375) - [DMN Designer] Import Java Classes Fix cases with special characters in PATH

# 0.20.0 (alpha)

- [KOGITO-7109](https://issues.redhat.com/browse/KOGITO-7109) - [DMN Designer] New Boxed Expression editor - Copy & paste values with newline
- [KOGITO-4172](https://issues.redhat.com/browse/KOGITO-4172) - [DMN Designer] New Boxed Expression editor - User must be able to create new lines by using shortcuts

# 0.19.0 (alpha)

- [KOGITO-6399](https://issues.redhat.com/browse/KOGITO-6399) - DMN Expression Editor - undo decision table annotation column
- [KOGITO-6417](https://issues.redhat.com/browse/KOGITO-6417) - [DMN Designer] Undo/redo in Boxed Expression Editor for editable cells is not working properly
- [KOGITO-6911](https://issues.redhat.com/browse/KOGITO-6911) - Adding a new DMN Runner input row using the Form '+' button is broken
- [KOGITO-6932](https://issues.redhat.com/browse/KOGITO-6932) - DMN editor: text annotation is not saved correctly when creating it by copy and paste
- [KOGITO-7067](https://issues.redhat.com/browse/KOGITO-7067) - [DMN Designer] DMN Editor: Slowness while opening large DMN file
- [KOGITO-6859](https://issues.redhat.com/browse/KOGITO-6859) - [DMN Editor] Enabling Import Java Classes feature
- [KOGITO-6608](https://issues.redhat.com/browse/KOGITO-6608) - Implement header cells keyboard navigation and editing on the Boxed Expression component
- [KOGITO-6915](https://issues.redhat.com/browse/KOGITO-6915) - Add visual regression tests to Cypress
- [KOGITO-6918](https://issues.redhat.com/browse/KOGITO-6918) - [DMN Designer] interaction with Name and Data Type popover with keyboard
- [KOGITO-7040](https://issues.redhat.com/browse/KOGITO-7040) - [DMN Designer] Finalizing Import Java Classes
- [KOGITO-7103](https://issues.redhat.com/browse/KOGITO-7103) - Wrong save behavior on desktop channel
- [KOGITO-7096](https://issues.redhat.com/browse/KOGITO-7096) - DMN Runner - form empty state is not working

# 0.18.0 (alpha)

- [KOGITO-5735](https://issues.redhat.com/browse/KOGITO-5735) - Stunner - Provide an initial JS / TS API to interact with nodes and connectors
- [KOGITO-6830](https://issues.redhat.com/browse/KOGITO-6830) - Remove `kie-soup-bom`dependency from the `stunner-editors` package
- [KOGITO-6841](https://issues.redhat.com/browse/KOGITO-6841) - Remove `kie-parent` from the `stunner-editors` package

# 0.17.0 (alpha)

- [KOGITO-4936](https://issues.redhat.com/browse/KOGITO-4936) - [DMN Designer] React/GWT - Import Java classes as data objects on Kogito - UI component
- [KOGITO-6276](https://issues.redhat.com/browse/KOGITO-6276) - [DMN Designer] Integrate Import Java Classes component to JavaCodeCompletion service
- [KOGITO-4686](https://issues.redhat.com/browse/KOGITO-4686) - Cannot open DMN/BPMN files from command line with VS Code
- [KOGITO-6693](https://issues.redhat.com/browse/KOGITO-6693) - Java code completion configuration
- [KOGITO-6704](https://issues.redhat.com/browse/KOGITO-6704) - [DMN Designer] Data Type Constraint overflow on Documentation page
- [KOGITO-6421](https://issues.redhat.com/browse/KOGITO-6421) - [DMN Designer] new editor toggle sanity checks are disabled for decision tables
- [KOGITO-6496](https://issues.redhat.com/browse/KOGITO-6496) - Remove unused/unnecessary dependencies with KIE V7 from `stunner-editors`
- [KOGITO-6671](https://issues.redhat.com/browse/KOGITO-6771) - [DMN Designer] Question, Allowed Answers on Documentation page
- [KOGITO-6703](https://issues.redhat.com/browse/KOGITO-6703) - [DMN Designer] Text Annotation on Documentation page
- [KOGITO-6181](https://issues.redhat.com/browse/KOGITO-6181) - Stunner-based editors are losing focus when asked for the SVG

# 0.16.0 (alpha)

- [KOGITO-6144](https://issues.redhat.com/browse/KOGITO-6144) - DMN Editor missing xml-prolog for UTF-8 encoding
- [KOGITO-6193](https://issues.redhat.com/browse/KOGITO-6193) - [DMN Designer] new editor toggle sanity checks are broken
- [KOGITO-6301](https://issues.redhat.com/browse/KOGITO-6301) - Changing data type doens´t resize the table correctly
- [KOGITO-6302](https://issues.redhat.com/browse/KOGITO-6302) - Changing data types can break the inputs
- [KOGITO-6323](https://issues.redhat.com/browse/KOGITO-6323) - DMN "Elbow lines" for association doesn't work
- [KOGITO-6405](https://issues.redhat.com/browse/KOGITO-6405) - Improve VSCode Java Completion Plugin dependency versions
- [KOGITO-6572](https://issues.redhat.com/browse/KOGITO-6572) - [DMN Editor] Styling regression

# 0.15.0 (alpha)

- [KOGITO-6222](https://issues.redhat.com/browse/KOGITO-6222) - [DMN Designer] Open Imported DMN from current model
- [KOGITO-6132](https://issues.redhat.com/browse/KOGITO-6132) - [DMN Designer] Pressing backspace when editing a node deletes the node
- [KOGITO-6036](https://issues.redhat.com/browse/KOGITO-6036) - Use html `<input type='color'>` picker

# 0.14.1 (alpha)

- [KOGITO-6226](https://issues.redhat.com/browse/KOGITO-6226) - Editor content sanitization
- [KOGITO-6233](https://issues.redhat.com/browse/KOGITO-6233) - [DMN Designer] User changes are lost

# 0.14.0 (alpha)

- [KOGITO-2099](https://issues.redhat.com/browse/KOGITO-2099) - Generate a SVG diagram automatically on each BPMN/DMN diagrams save
- [KOGITO-6083](https://issues.redhat.com/browse/KOGITO-6083) - [DMN Designer] Improve BKM description rendering on documentation tab
- [KOGITO-5973](https://issues.redhat.com/browse/KOGITO-5973) - Stunner - Create an initial JS / TS API for accessing the canvas and its elements
- [KOGITO-2133](https://issues.redhat.com/browse/KOGITO-2133) - [VSCode] Custom editor save issues
- [KOGITO-2553](https://issues.redhat.com/browse/KOGITO-2553) - Editors - Editing the node name and pressing enter to confirm
- [KOGITO-6033](https://issues.redhat.com/browse/KOGITO-6033) - [DMN Designer] Unreadable data type information in PDF document that shows DMN decision model
- [KOGITO-6037](https://issues.redhat.com/browse/KOGITO-6037) - [DMN Designer] Background color do not work on DMN Editor (online and VSCode)
- [KOGITO-6021](https://issues.redhat.com/browse/KOGITO-6021) - [DMN Designer] Multiple DRDs - Renaming a DRD freezes the browser

# 0.13.0 (alpha)

- [DROOLS-6477](https://issues.redhat.com/browse/DROOLS-6477) - Collections Data Objects can be filled with expressions only.
- [KOGITO-3909](https://issues.redhat.com/browse/KOGITO-3909) - Standalone DMN editor missing isDirty indication on data type or included models change
- [KOGITO-5149](https://issues.redhat.com/browse/KOGITO-5149) - Create the second step of the Wizard - Create the collapsible/expandable list of future Data Types
- [KOGITO-5725](https://issues.redhat.com/browse/KOGITO-5725) - Enable extensions for github.dev.

# 0.12.0 (alpha)

- [KOGITO-1686](https://issues.redhat.com/browse/KOGITO-1686) - DMN target position is not stored
- [KOGITO-4941](https://issues.redhat.com/browse/KOGITO-4941) - [DMN Editor] Ctrl-B always converts field to structure and nests
- [KOGITO-5091](https://issues.redhat.com/browse/KOGITO-5091) - VSCode DMN, BPMN editor - creating connection can't be cancelled easily
- [KOGITO-5241](https://issues.redhat.com/browse/KOGITO-5241) - Stunner - Resize Icon remains displayed
- [KOGITO-5571](https://issues.redhat.com/browse/KOGITO-5571) - [Test Scenario] No effects when assigning a not-expression Simple Type column to expression type (and viceversa)
- [KOGITO-5594](https://issues.redhat.com/browse/KOGITO-5594) - [Stunner] bend point modification causes diagram inaccessible
- [KOGITO-5274](https://issues.redhat.com/browse/KOGITO-5274) - Stunner - Line splicing
- [KOGITO-5382](https://issues.redhat.com/browse/KOGITO-5382) - Verify support for node/event metadata attribues feature
- [KOGITO-5489](https://issues.redhat.com/browse/KOGITO-5489) - [DMN Designer] When users create a node by using a shortcut, it's not created above
- [KOGITO-5496](https://issues.redhat.com/browse/KOGITO-5496) - Update vscode-extension-tester to 4.1.0
- [KOGITO-5648](https://issues.redhat.com/browse/KOGITO-5648) - [DMN/BPMN] Wired web apps - Fix doc screenshot
- [KOGITO-4413](https://issues.redhat.com/browse/KOGITO-4413) - Implement - designs for orthogonal lines between diagram nodes
- [KOGITO-4765](https://issues.redhat.com/browse/KOGITO-4765) - [Test Scenario] - Errors when executing models using imported inputs and/or decisions nodes
- [KOGITO-4978](https://issues.redhat.com/browse/KOGITO-4978) - Stunner - Make new nodes editable automatically
- [KOGITO-4979](https://issues.redhat.com/browse/KOGITO-4979) - Stunner - Resize control points - Fixes & UX improvements
- [KOGITO-5119](https://issues.redhat.com/browse/KOGITO-5119) - [DMN Designer] Add support for bend-points on connectors
- [KOGITO-5208](https://issues.redhat.com/browse/KOGITO-5208) - [Stunner] Lienzo - Migration to native interfaces
- [KOGITO-5242](https://issues.redhat.com/browse/KOGITO-5242) - Stunner - Alignment helpers missing during node resize
- [KOGITO-5549](https://issues.redhat.com/browse/KOGITO-5549) - Stunner - WID files with comments and Imports can't be loaded

# 0.11.0 (alpha)

### New features:

- [KOGITO-4043](https://issues.redhat.com/browse/KOGITO-4043) - The nodes should be created on top of the selected node in DMN editor
- [KOGITO-5132](https://issues.redhat.com/browse/KOGITO-5132) - BPMN Editor - Improve SVG generated ids
- [KOGITO-3274](https://issues.redhat.com/browse/KOGITO-3274) - [DMN Designer] Read-only mode - Connectors appear differently on read-only mode
- [KOGITO-5135](https://issues.redhat.com/browse/KOGITO-5135) - [SceSim Designer] HiDPI is not working as expected
- [KOGITO-5142](https://issues.redhat.com/browse/KOGITO-5142) - [DMN/BPMN] Sync kogito-editors-java with latest translations
- [KOGITO-5378](https://issues.redhat.com/browse/KOGITO-5378) - Kogito Tooling VS Code extensions Workspaces Trust
- [KOGITO-4671](https://issues.redhat.com/browse/KOGITO-4671) - New elements should always be connected by their central magnetic point
- [KOGITO-4980](https://issues.redhat.com/browse/KOGITO-4980) - Stunner - Palette fixes & improvements

### Fixed issues:

- [KOGITO-3998](https://issues.redhat.com/browse/KOGITO-3998) - It's not possible to save arrow edits
- [KOGITO-4712](https://issues.redhat.com/browse/KOGITO-4712) - SceSim Editor does not work in Eclipse Theia
- [KOGITO-4935](https://issues.redhat.com/browse/KOGITO-4935) - [BC included] [DMN/BPMN editor] Sometimes clicking outside doesn't unselect nodes
- [KOGITO-4977](https://issues.redhat.com/browse/KOGITO-4977) - Stunner - Texts overlap toolboxes
- [KOGITO-5003](https://issues.redhat.com/browse/KOGITO-5003) - [BC Included] DMN editor removing edges for duplicate Decision Nodes on canvas
- [KOGITO-5011](https://issues.redhat.com/browse/KOGITO-5011) - Stunner - Unknown Custom tasks in Designer makes Diagram Explorer empty
- [KOGITO-5021](https://issues.redhat.com/browse/KOGITO-5021) - Clear selection button doesn't work on Testing Tools when use click property first time.
- [KOGITO-5168](https://issues.redhat.com/browse/KOGITO-5168) - Stunner - Editing text using Inline editor is shown over Properties panel or Expanded Palette
- [KOGITO-5169](https://issues.redhat.com/browse/KOGITO-5169) - Stunner - The order of Custom tasks in the palette is different with every process opening

# 0.10.0 (alpha)

### New features:

- [KOGITO-4179](https://issues.redhat.com/browse/KOGITO-4179) - [DMN Designer] Data Types - Add popover for showing data types fields in the data types tab

### Fixed issues:

- [KOGITO-4530](https://issues.redhat.com/browse/KOGITO-4530) - [DMN Designer] Boxed Expressions - Decision Tables - HiDPI is not working as expected
- [KOGITO-4868](https://issues.redhat.com/browse/KOGITO-4868) - There is an additional scrollbar around the editor when it shouldn’t (SceSim only)
- [KOGITO-4954](https://issues.redhat.com/browse/KOGITO-4954) - [Test Scenario] In some conditions Tabs disappear
- [KOGITO-4872](https://issues.redhat.com/browse/KOGITO-4872) - SceSim editor needs an ErrorPage for when `setContent` fails

# 0.9.1 (alpha)

## New features:

Infrastructure

- [KOGITO-4914](https://issues.redhat.com/browse/KOGITO-4914) - The SVG icon is broken on vscode-insiders

Editors

--

## Fixed issues:

Editors

- [KOGITO-2197](https://issues.redhat.com/browse/KOGITO-2197) - [Scesim Editor] Bottom scroll bar getting hide
- [KOGITO-3192](https://issues.redhat.com/browse/KOGITO-3192) - [DMN Designer] Multiple DRDs support - The undo/redo are lost when user changes between diagrams
- [KOGITO-4916](https://issues.redhat.com/browse/KOGITO-4916) - [DMN Designer] Error during the save/marshaller of specific diagrams

# 0.9.0 (alpha)

## New features:

Infrastructure

- [KOGITO-4349](https://issues.redhat.com/browse/KOGITO-4349) - Publish VS Code Extensions to OpenVSX registry

Editors

- [KOGITO-4190](https://issues.redhat.com/browse/KOGITO-4190) - SceSim runner does not display reason for failure

## Fixed issues:

Infrastructure

--

Editors

- [KOGITO-4266](https://issues.redhat.com/browse/KOGITO-4266) - [DMN Designer] Decision Service is missing inputData element in model with multiple DRDs

# 0.8.6 (alpha)

--

# 0.8.5 (alpha)

## New features:

Infrastructure

- [KOGITO-4666](https://issues.redhat.com/browse/KOGITO-4666) - Converge the CSS to avoid conflicts between PF3 and PF4

Editors

--

## Fixed issues:

Infrastructure

--

Editors

- [KOGITO-4257](https://issues.redhat.com/browse/KOGITO-4257) - Importing and modeling decision models is too slow for productive modeling
- [KOGITO-4265](https://issues.redhat.com/browse/KOGITO-4265) - [DMN Designer] Decision Services - The parameters order in the properties panel is not correct
- [KOGITO-4368](https://issues.redhat.com/browse/KOGITO-4368) - DMN Editor wrong edge arrow tip connection on reopen
- [KOGITO-4500](https://issues.redhat.com/browse/KOGITO-4500) - [DMN Designer] DMN schema/model validation errors when model has AUTO-SOURCE or AUTO-TARGET connections
- [KOGITO-4533](https://issues.redhat.com/browse/KOGITO-4533) - Scesim assets are broken in VS Code extension
- [KOGITO-4539](https://issues.redhat.com/browse/KOGITO-4539) - [DMN Designer] DMN takes too long to open models with too many nodes

# 0.8.4 (alpha)

--

# 0.8.3 (alpha)

## New features:

Editors

- [[KOGITO-4122](https://issues.redhat.com/browse/KOGITO-4122)] - [Test Scenario Editor] Improve Test Scenario creation UX
- [[KOGITO-3302](https://issues.redhat.com/browse/KOGITO-3302)] - Allow to select any DMN asset in Wizard

### Fixed issues:

VS Code

- [[KOGITO-3718](https://issues.redhat.com/browse/KOGITO-3718)] - Importing DMN as Included Model in VS Code on Windows

Editors

- [[KOGITO-4049](https://issues.redhat.com/browse/KOGITO-4122)] - Cannot open Violation Scenarios.scesim in VScode
- [[KOGITO-4197](https://issues.redhat.com/browse/KOGITO-4197)] - [DMN Designer] DMN 1.1 model can not be fixed to proper DMN 1.2

# 0.8.2 (alpha)

--

# 0.8.1 (alpha)

## New features

Editors

- [[KOGITO-3805](https://issues.redhat.com/browse/KOGITO-3805)] - [DMN Designer] Convert DMN 1.1/1.3 models to version 1.2

## Fixed issues

VS Code

- [[KOGITO-2629](https://issues.redhat.com/browse/KOGITO-2629)] - [VSCode] Undo/redo command don't fire for webviews if used from command palette
- [[KOGITO-3808](https://issues.redhat.com/browse/KOGITO-3808)] - Fix Keyboard Shortcuts modal title on VS Code dark theme
- [[KOGITO-3884](https://issues.redhat.com/browse/KOGITO-3884)] - Save SVG file using the kieserver naming convention
- [[KOGITO-3901](https://issues.redhat.com/browse/KOGITO-3901)] - Cannot Include DMNs on VS Code- Kogito Bundle on Windows
- [[KOGITO-3348](https://issues.redhat.com/browse/KOGITO-3348)] - Fix Open SVG popup to not open SVG when clicking the X button

Editors

- [[KOGITO-2770](https://issues.redhat.com/browse/KOGITO-2770)] - [Test Scenario Editor] Changes on Setting Docks must activate isDirty status
- [[KOGITO-3696](https://issues.redhat.com/browse/KOGITO-3696)] - DMN Editor regression failing display edge when xml missing DMNDI

# 0.8.0 (alpha)

## Fixed issues

Editors

- [[KOGITO-3192](https://issues.redhat.com/browse/KOGITO-3192)] - [DMN Designer] Multiple DRDs support - The undo/reado are lost when user changes between diagrams
- [[KOGITO-3364](https://issues.redhat.com/browse/KOGITO-3364)] - [DMN Designer] Multiple DRDs support - When a node is deleted in the DRG, undo/redo operations do not work properly
- [[KOGITO-3366](https://issues.redhat.com/browse/KOGITO-3366)] - [DMN Designer] Boxed Expression - Decision Tables - Users lost constraints when they change the focus

# 0.7.1 (alpha)

## New features

Editors

- [[KOGITO-2664](https://issues.redhat.com/browse/KOGITO-2664)] - [DMN Designer] Multiple DRDs support

## Fixed issues

Editors

- [[KOGITO-2348](https://issues.redhat.com/browse/KOGITO-2348)] - Scenario fails if model includes another one
- [[KOGITO-2773](https://issues.redhat.com/browse/KOGITO-2773)] - [Test Scenario Editor] BC - Kogito generated scesim file are in same cases not compatible
- [[KOGITO-3152](https://issues.redhat.com/browse/KOGITO-3152)] - [DMN Designer] PMML support - function parameters generation
- [[KOGITO-3571](https://issues.redhat.com/browse/KOGITO-3571)] - [DMN Designer] Multiple DRDs support - Information requirements are duplicated into the DMN XML

# 0.7.0 (alpha)

## New features

VS Code

- [[KOGITO-1517](https://issues.redhat.com/browse/KOGITO-1517)] - Improve accessibility on file with unsupported extension error
- [[KOGITO-2210](https://issues.redhat.com/browse/KOGITO-2210)] - Define Integration API for Java Backend Services
- [[KOGITO-2863](https://issues.redhat.com/browse/KOGITO-2863)] - Think about removing a default Envelope from `embedded-editor`
- [[KOGITO-2887](https://issues.redhat.com/browse/KOGITO-2887)] - Implement a sample service
- [[KOGITO-3042](https://issues.redhat.com/browse/KOGITO-3042)] - Replace MessageBusClient with proxified version of ApiToConsume
- [[KOGITO-3043](https://issues.redhat.com/browse/KOGITO-3043)] - Provide locale information in a way that GWT can read
- [[KOGITO-3056](https://issues.redhat.com/browse/KOGITO-3056)] - Move I18nService and and its Envelope/Channel APIs to its own module
- [[KOGITO-3057](https://issues.redhat.com/browse/KOGITO-3057)] - Add a initialLocale prop on I18nDictionariesProvider
- [[KOGITO-3096](https://issues.redhat.com/browse/KOGITO-3096)] - CI for kogito-tooling-java
- [[KOGITO-3100](https://issues.redhat.com/browse/KOGITO-3100)] - Documentation for backend services
- [[KOGITO-2984](https://issues.redhat.com/browse/KOGITO-2984)] - Use i18n dictionaries on VS Code extension backend
- [[KOGITO-3205](https://issues.redhat.com/browse/KOGITO-3205)] - Create test runner service running on the backend infra

Editors

- [[KOGITO-543](https://issues.redhat.com/browse/KOGITO-543)] - DMN - Read Only mode
- [[KOGITO-1716](https://issues.redhat.com/browse/KOGITO-1716)] - [Test Scenario Editor] Show warning if user opens scesim file for rule based test scenario in VSCode
- [[KOGITO-2674](https://issues.redhat.com/browse/KOGITO-2674)] - [DMN Designer] Multiple DRDs support - Context menu component
- [[KOGITO-2675](https://issues.redhat.com/browse/KOGITO-2675)] - [DMN Designer] Multiple DRDs support - Context menu - Show the DRD clickable icon when node is selected
- [[KOGITO-2761](https://issues.redhat.com/browse/KOGITO-2761)] - [DMN Designer] PMML support - Resource content API integration
- [[KOGITO-2895](https://issues.redhat.com/browse/KOGITO-2895)] - [DMN Designer] PMML support - PMML Marshaller integration
- [[KOGITO-2896](https://issues.redhat.com/browse/KOGITO-2896)] - [DMN Designer] PMML support - Using a linked PMML inside the editor
- [[KOGITO-3022](https://issues.redhat.com/browse/KOGITO-3022)] - [DMN Designer] Multiple DRDs support - Context menu - When multiple nodes are selected, showing context menu with right click

## Fixed issues

VS Code

- [[KOGITO-3313](https://issues.redhat.com/browse/KOGITO-3313)] - Fix on filename change
- [[KOGITO-3326](https://issues.redhat.com/browse/KOGITO-3326)] - Enable EmbeddedEditor to support an update on the StateControl instance
- [[KOGITO-3417](https://issues.redhat.com/browse/KOGITO-3417)] - EditorEnvelopeView reference should be get with a function to be updated
- [[KOGITO-3314](https://issues.redhat.com/browse/KOGITO-3314)] - Broken link on popup due to circular dependency issue

Editors

- [[KOGITO-2060](https://issues.redhat.com/browse/KOGITO-2060)] - [Test Scenario Editor] Order of facts of Test Tools in Kogito and BC is different
- [[KOGITO-3153](https://issues.redhat.com/browse/KOGITO-3153)] - [DMN Designer] PMML support - run via quarkus
- [[KOGITO-3155](https://issues.redhat.com/browse/KOGITO-3155)] - [SCESIM] Test DMN model including PMML
- [[KOGITO-3504](https://issues.redhat.com/browse/KOGITO-3504)] - Interrogation mark cannot be used on new inline editor

# 0.6.1 (alpha)

## New features

VS Code

- [KOGITO-3089](https://issues.redhat.com/browse/KOGITO-3089) - Add button on VS Code to generate SVG for BPMN and DMN editors

Editors

- No new features

## Fixed issues

VS Code

- [KOGITO-2579](https://issues.redhat.com/browse/KOGITO-2579) - Custom Editor VS Code issues on 1.46 version (probably fixed on 1.47)
- [KOGITO-1689](https://issues.redhat.com/browse/KOGITO-1689) - Save when multiple assets opened
- [KOGITO-2134](https://issues.redhat.com/browse/KOGITO-2134) - [VSCode] Allow custom editors to hook into Edit menu actions
- [KOGITO-2135](https://issues.redhat.com/browse/KOGITO-2135) - [VSCode] Custom editor does not open properly
- [KOGITO-2619](https://issues.redhat.com/browse/KOGITO-2619) - scrolling a nested Decision Table in VSCode DMN Editor messed up the editor screen
- [KOGITO-1980](https://issues.redhat.com/browse/KOGITO-1980) - Update labels from `VSCode` to `VS Code`

Editors

- [KOGITO-1883](https://issues.redhat.com/browse/KOGITO-1883) - [Test Scenario Editor] Search DMN files over subfolders doesn't work in Windows Environment
- [KOGITO-2953](https://issues.redhat.com/browse/KOGITO-2953) - Fix Guided Tour styles

# 0.6.0 (alpha)

## New features

VS Code

- [KOGITO-2076](https://issues.redhat.com/browse/KOGITO-2076) Open File API
- [KOGITO-2180](https://issues.redhat.com/browse/KOGITO-2180) Use KeyboardShortcutsAPI with StateControlAPI (Undo/Redo)
- [KOGITO-2542](https://issues.redhat.com/browse/KOGITO-2542) Update Hub to install VS Code extension from Marketplace
- [KOGITO-766](https://issues.redhat.com/browse/KOGITO-766) Keyboard Shortcuts API
- [KOGITO-1373](https://issues.redhat.com/browse/KOGITO-1373) Integrate the new StateControl API (Undo/Redo/Is Dirty) on the different channels
- [KOGITO-2132](https://issues.redhat.com/browse/KOGITO-2132) Adapt to new VS Code 1.46

Editors

- [KOGITO-1776](https://issues.redhat.com/browse/KOGITO-1776) [DMN Designer] Create a "Load Projects From Client" button
- [KOGITO-2615](https://issues.redhat.com/browse/KOGITO-2615) [Guided Tour - DMN] All anchors in the DMN guide tour must be target="\_blank"
- [KOGITO-2137](https://issues.redhat.com/browse/KOGITO-2137) [Scesim Editor] Integrate SceSim with State Control API
- [KOGITO-2337](https://issues.redhat.com/browse/KOGITO-2337) [SCESIM Editor] Enable UNDO/REDO
- [KOGITO-697](https://issues.redhat.com/browse/KOGITO-697) [DMN Designer] Support Included Models on Kogito

## Fixed issues

VS Code

- [KOGITO-745](https://issues.redhat.com/browse/KOGITO-745) Command Y to undo isn't mapped
- [KOGITO-2490](https://issues.redhat.com/browse/KOGITO-2490) Shortcuts should not be triggered when typing on text inputs
- [KOGITO-2493](https://issues.redhat.com/browse/KOGITO-2493) Update and use @types/vscode
- [KOGITO-2580](https://issues.redhat.com/browse/KOGITO-2580) Add noImplicitAny property back into tsconfig.json
- [KOGITO-2581](https://issues.redhat.com/browse/KOGITO-2581) Delete isDirty method on core-api

Editors

- [KOGITO-1552](https://issues.redhat.com/browse/KOGITO-1552) [DMN Designer] Open a DMN file with an included model - DRG Elements
- [KOGITO-1553](https://issues.redhat.com/browse/KOGITO-1553) [DMN Designer] Open a DMN file with an included model - Included Models tab
