/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License. 
 */


package org.kie.workbench.common.forms.common.rendering.client.util.valueConverters;

import org.jboss.errai.databinding.client.api.Converter;

public class CharacterToStringConverter implements Converter<Character, String> {

    @Override
    public Class<Character> getModelType() {
        return Character.class;
    }

    @Override
    public Class<String> getComponentType() {
        return String.class;
    }

    @Override
    public Character toModelValue(String componentValue) {
        if(componentValue == null || componentValue.isEmpty()) {
            return null;
        }
        return componentValue.charAt(0);
    }

    @Override
    public String toWidgetValue(Character modelValue) {
        if (modelValue == null) {
            return null;
        }
        return String.valueOf(modelValue);
    }
}
