/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.template;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.iotdb.isession.template.TemplateNode;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class MeasurementNode
extends TemplateNode {
    private TSDataType dataType;
    private TSEncoding encoding;
    private CompressionType compressionType;

    public MeasurementNode(String name, TSDataType dataType, TSEncoding encoding, CompressionType compressionType) {
        super(name);
        this.dataType = dataType;
        this.encoding = encoding;
        this.compressionType = compressionType;
    }

    public boolean isMeasurement() {
        return true;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.getName(), (OutputStream)stream);
        ReadWriteIOUtils.write((byte)this.getDataType().serialize(), (OutputStream)stream);
        ReadWriteIOUtils.write((byte)this.getEncoding().serialize(), (OutputStream)stream);
        ReadWriteIOUtils.write((byte)this.getCompressionType().serialize(), (OutputStream)stream);
    }
}

