/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.customizer.analysis;

import org.apache.iotdb.udf.api.customizer.analysis.FunctionAnalysis;
import org.apache.iotdb.udf.api.type.Type;

public class AggregateFunctionAnalysis
implements FunctionAnalysis {
    private final Type outputDataType;
    private final boolean removable;

    private AggregateFunctionAnalysis(Type outputDataType, boolean removable) {
        this.outputDataType = outputDataType;
        this.removable = removable;
    }

    public Type getOutputDataType() {
        return this.outputDataType;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public static class Builder {
        private Type outputDataType;
        private boolean removable = false;

        public Builder outputDataType(Type outputDataType) {
            this.outputDataType = outputDataType;
            return this;
        }

        public Builder removable(boolean removable) {
            this.removable = removable;
            return this;
        }

        public AggregateFunctionAnalysis build() throws IllegalArgumentException {
            if (this.outputDataType == null) {
                throw new IllegalArgumentException("AggregateFunctionAnalysis outputDataType is not set.");
            }
            return new AggregateFunctionAnalysis(this.outputDataType, this.removable);
        }
    }
}

