/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.io.LineReaderInputStreamAdaptor;
import org.apache.james.mime4j.io.MaxLineLimitException;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Assert;
import org.junit.Test;

public class LineReaderInputStreamAdaptorTest {
    private static LineReaderInputStreamAdaptor create(String s) {
        return new LineReaderInputStreamAdaptor(InputStreams.createAscii((CharSequence)s));
    }

    private static LineReaderInputStreamAdaptor create(byte[] b) {
        return new LineReaderInputStreamAdaptor(InputStreams.create((byte[])b));
    }

    private static LineReaderInputStreamAdaptor create(byte[] b, int bufSize) {
        return new LineReaderInputStreamAdaptor(InputStreams.create((byte[])b), bufSize);
    }

    @Test
    public void testBasicOperations() throws Exception {
        String text = "ah blahblah";
        LineReaderInputStreamAdaptor instream = LineReaderInputStreamAdaptorTest.create(text);
        Assert.assertEquals((long)97L, (long)instream.read());
        Assert.assertEquals((long)104L, (long)instream.read());
        Assert.assertEquals((long)32L, (long)instream.read());
        byte[] tmp1 = new byte[4];
        Assert.assertEquals((long)4L, (long)instream.read(tmp1));
        Assert.assertEquals((long)4L, (long)instream.read(tmp1));
        Assert.assertEquals((long)-1L, (long)instream.read(tmp1));
        Assert.assertEquals((long)-1L, (long)instream.read(tmp1));
        Assert.assertEquals((long)-1L, (long)instream.read());
        Assert.assertEquals((long)-1L, (long)instream.read());
        instream.close();
    }

    @Test
    public void testBasicReadLine() throws Exception {
        String[] teststrs = new String[5];
        teststrs[0] = "Hello\r\n";
        teststrs[1] = "This string should be much longer than the size of the input buffer which is only 16 bytes for this test\r\n";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            sb.append("123456789 ");
        }
        sb.append("and stuff like that\r\n");
        teststrs[2] = sb.toString();
        teststrs[3] = "\r\n";
        teststrs[4] = "And goodbye\r\n";
        ByteArrayBuffer buf = new ByteArrayBuffer(128);
        for (String teststr : teststrs) {
            byte[] b = ContentUtil.toAsciiByteArray((String)teststr);
            buf.append(b, 0, b.length);
        }
        byte[] raw = buf.toByteArray();
        LineReaderInputStreamAdaptor instream = LineReaderInputStreamAdaptorTest.create(raw);
        ByteArrayBuffer linebuf = new ByteArrayBuffer(8);
        for (String teststr : teststrs) {
            linebuf.clear();
            instream.readLine(linebuf);
            String s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
            Assert.assertEquals((Object)teststr, (Object)s);
        }
        Assert.assertEquals((long)-1L, (long)instream.readLine(linebuf));
        Assert.assertEquals((long)-1L, (long)instream.readLine(linebuf));
        instream.close();
    }

    @Test
    public void testReadEmptyLine() throws Exception {
        String teststr = "\n\n\r\n\r\r\n\n\n\n\n\n";
        byte[] raw = teststr.getBytes("US-ASCII");
        LineReaderInputStreamAdaptor instream = LineReaderInputStreamAdaptorTest.create(raw);
        ByteArrayBuffer linebuf = new ByteArrayBuffer(8);
        linebuf.clear();
        instream.readLine(linebuf);
        String s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\r\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\r\r\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\n", (Object)s);
        Assert.assertEquals((long)-1L, (long)instream.readLine(linebuf));
        Assert.assertEquals((long)-1L, (long)instream.readLine(linebuf));
        instream.close();
    }

    @Test
    public void testReadEmptyLineMaxLimit() throws Exception {
        String teststr = "1234567890\r\n";
        byte[] raw = teststr.getBytes("US-ASCII");
        LineReaderInputStreamAdaptor instream1 = LineReaderInputStreamAdaptorTest.create(raw, 13);
        ByteArrayBuffer linebuf = new ByteArrayBuffer(8);
        linebuf.clear();
        instream1.readLine(linebuf);
        instream1.close();
        LineReaderInputStreamAdaptor instream2 = LineReaderInputStreamAdaptorTest.create(raw, 12);
        linebuf.clear();
        try {
            instream2.readLine(linebuf);
            Assert.fail((String)"MaxLineLimitException should have been thrown");
        }
        catch (MaxLineLimitException maxLineLimitException) {
            // empty catch block
        }
        instream2.close();
    }
}

