/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultipartTokensTest {
    private static final String BODY = "A Preamble\r\n--1729\r\n\r\nSimple plain text\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nSome more text\r\n--1729--\r\nAn Epilogue\r\n";
    public static final String MESSAGE = "To: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nContent-Type: multipart/mixed;boundary=1729\r\n\r\nA Preamble\r\n--1729\r\n\r\nSimple plain text\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nSome more text\r\n--1729--\r\nAn Epilogue\r\n";
    public static final String COMPLEX_MESSAGE = "To: Wile E. Cayote <wile@example.org>\r\nFrom: Road Runner <runner@example.org>\r\nDate: Tue, 19 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nContent-Type: multipart/mixed;boundary=42\r\n\r\nA little preamble\r\n--42\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nRhubard!\r\n--42\r\nContent-Type: message/rfc822\r\n\r\nTo: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nContent-Type: multipart/mixed;boundary=1729\r\n\r\nA Preamble\r\n--1729\r\n\r\nSimple plain text\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nSome more text\r\n--1729--\r\nAn Epilogue\r\n\r\n--42\r\n\r\nCustard!\r\n--42--\r\nA little epilogue\r\n";
    public static final String COMPLEX_QP_MESSAGE = "Content-Transfer-Encoding: quoted-printable\r\nContent-Type: message/rfc822; charset=us-ascii\r\n\r\nSubject: The subject\r\nContent-Type: multipart/alternative;\r\n        boundary=3D=22----=3DNextPart=22\r\n\r\nThis is a multi-part message in MIME format.\r\n\r\n------=3DNextPart\r\nContent-Type: text/plain;\r\n        charset=3D=22iso-8859-1=22\r\n\r\nSome text\r\n\r\n------=3DNextPart\r\nContent-Type: text/html;\r\n        charset=3D=22iso-8859-1=22\r\n\r\n<HTML><BODY>=3D Some HTML =3D</BODY></HTML>\r\n------=3DNextPart--\r\n\r\n\r\n";
    MimeTokenStream parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new MimeTokenStream();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testShouldParseSimpleMessage() throws Exception {
        this.parser.parse(InputStreams.create((CharSequence)MESSAGE, (Charset)Charsets.US_ASCII));
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_START_MULTIPART);
        this.checkState(EntityState.T_PREAMBLE);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_EPILOGUE);
        this.checkState(EntityState.T_END_MULTIPART);
        this.checkState(EntityState.T_END_MESSAGE);
        this.checkState(EntityState.T_END_OF_STREAM);
    }

    @Test
    public void testShouldParseMoreComplexMessage() throws Exception {
        String message = "Content-Type: multipart/alternative; boundary=\"outer-boundary\"\r\n\r\n--outer-boundary\r\nContent-Type: multipart/alternative; boundary=\"inner-boundary\"\r\n\r\n--inner-boundary\r\nContent-Type: text/plain\r\n\r\nSome text\r\n--inner-boundary--\r\n\r\nfoo\r\n--outer-boundary--\r\n";
        this.parser.parse(InputStreams.create((CharSequence)message, (Charset)Charsets.US_ASCII));
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_START_MULTIPART);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_START_MULTIPART);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_EPILOGUE);
        this.checkState(EntityState.T_END_MULTIPART);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_END_MULTIPART);
        this.checkState(EntityState.T_END_MESSAGE);
        this.checkState(EntityState.T_END_OF_STREAM);
    }

    @Test
    public void testShouldParseMessageWithEmbeddedMessage() throws Exception {
        this.parser.parse(InputStreams.create((CharSequence)COMPLEX_MESSAGE, (Charset)Charsets.US_ASCII));
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_START_MULTIPART);
        this.checkState(EntityState.T_PREAMBLE);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_START_MESSAGE);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_START_MULTIPART);
        this.checkState(EntityState.T_PREAMBLE);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_EPILOGUE);
        this.checkState(EntityState.T_END_MULTIPART);
        this.checkState(EntityState.T_END_MESSAGE);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_EPILOGUE);
        this.checkState(EntityState.T_END_MULTIPART);
        this.checkState(EntityState.T_END_MESSAGE);
        this.checkState(EntityState.T_END_OF_STREAM);
    }

    @Test
    public void testShouldParseMessagesWithEmbeddedQuotedPrintableEncodedMessage() throws Exception {
        this.parser.parse(InputStreams.create((CharSequence)COMPLEX_QP_MESSAGE, (Charset)Charsets.US_ASCII));
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_START_MESSAGE);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_START_MULTIPART);
        this.checkState(EntityState.T_PREAMBLE);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        Assert.assertEquals((Object)"text/plain", (Object)this.parser.getBodyDescriptor().getMimeType());
        Assert.assertEquals((Object)"iso-8859-1", (Object)this.parser.getBodyDescriptor().getCharset());
        Assert.assertEquals((Object)"Some text\r\n", (Object)IOUtils.toString((InputStream)this.parser.getInputStream()));
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        Assert.assertEquals((Object)"text/html", (Object)this.parser.getBodyDescriptor().getMimeType());
        Assert.assertEquals((Object)"iso-8859-1", (Object)this.parser.getBodyDescriptor().getCharset());
        Assert.assertEquals((Object)"<HTML><BODY>= Some HTML =</BODY></HTML>", (Object)IOUtils.toString((InputStream)this.parser.getInputStream()));
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_EPILOGUE);
        this.checkState(EntityState.T_END_MULTIPART);
        this.checkState(EntityState.T_END_MESSAGE);
        this.checkState(EntityState.T_END_MESSAGE);
        this.checkState(EntityState.T_END_OF_STREAM);
    }

    @Test
    public void testMultipartMessageWithoutHeader() throws Exception {
        this.parser.parseHeadless(InputStreams.create((CharSequence)BODY, (Charset)Charsets.US_ASCII), "multipart/mixed;boundary=1729");
        this.checkState(EntityState.T_PREAMBLE);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_EPILOGUE);
        this.checkState(EntityState.T_END_MULTIPART);
        this.checkState(EntityState.T_END_MESSAGE);
        this.checkState(EntityState.T_END_OF_STREAM);
    }

    private void checkState(EntityState state) throws IOException, MimeException {
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)state), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
    }
}

