/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.RecursionMode;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MimeTokenNoRecurseTest {
    private static final String INNER_MAIL = "From: Timothy Tayler <tim@example.org>\r\nTo: Joshua Tetley <joshua@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Multipart Without RFC822 Part\r\nContent-Type: multipart/mixed;boundary=42\r\n\r\n--42\r\nContent-Type:text/plain; charset=US-ASCII\r\n\r\nFirst part of this mail\r\n--42\r\nContent-Type:text/plain; charset=US-ASCII\r\n\r\nSecond part of this mail\r\n--42--\r\n";
    private static final String MAIL_WITH_RFC822_PART = "MIME-Version: 1.0\r\nFrom: Timothy Tayler <tim@example.org>\r\nTo: Joshua Tetley <joshua@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Multipart With RFC822 Part\r\nContent-Type: multipart/mixed;boundary=1729\r\n\r\nA short premable\r\n--1729\r\n\r\nFirst part has no headers\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nSecond part is plain text\r\n--1729\r\nContent-Type: message/rfc822\r\n\r\nFrom: Timothy Tayler <tim@example.org>\r\nTo: Joshua Tetley <joshua@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Multipart Without RFC822 Part\r\nContent-Type: multipart/mixed;boundary=42\r\n\r\n--42\r\nContent-Type:text/plain; charset=US-ASCII\r\n\r\nFirst part of this mail\r\n--42\r\nContent-Type:text/plain; charset=US-ASCII\r\n\r\nSecond part of this mail\r\n--42--\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nLast part is plain text\r\n--1729--\r\nThe End";
    MimeTokenStream stream;

    @Before
    public void setUp() throws Exception {
        this.stream = new MimeTokenStream();
        byte[] bytes = ContentUtil.toAsciiByteArray((String)MAIL_WITH_RFC822_PART);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.stream.parse((InputStream)in);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testWhenRecurseShouldRecurseInnerMail() throws Exception {
        this.stream.setRecursionMode(RecursionMode.M_RECURSE);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_START_MULTIPART);
        this.nextIs(EntityState.T_PREAMBLE);
        this.nextShouldBeStandardPart(false);
        this.nextShouldBeStandardPart(true);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_START_MESSAGE);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_START_MULTIPART);
        this.nextShouldBeStandardPart(true);
        this.nextShouldBeStandardPart(true);
        this.nextIs(EntityState.T_END_MULTIPART);
        this.nextIs(EntityState.T_END_MESSAGE);
        this.nextIs(EntityState.T_END_BODYPART);
        this.nextShouldBeStandardPart(true);
        this.nextIs(EntityState.T_EPILOGUE);
        this.nextIs(EntityState.T_END_MULTIPART);
    }

    @Test
    public void testWhenRecurseShouldTreatInnerMailAsAnyOtherPart() throws Exception {
        this.stream.setRecursionMode(RecursionMode.M_NO_RECURSE);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_START_MULTIPART);
        this.nextIs(EntityState.T_PREAMBLE);
        this.nextShouldBeStandardPart(false);
        this.nextShouldBeStandardPart(true);
        this.nextShouldBeStandardPart(true);
        this.nextShouldBeStandardPart(true);
        this.nextIs(EntityState.T_EPILOGUE);
        this.nextIs(EntityState.T_END_MULTIPART);
    }

    @Test
    public void testWhenNoRecurseInputStreamShouldContainInnerMail() throws Exception {
        this.stream.setRecursionMode(RecursionMode.M_NO_RECURSE);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_START_MULTIPART);
        this.nextIs(EntityState.T_PREAMBLE);
        this.nextShouldBeStandardPart(false);
        this.nextShouldBeStandardPart(true);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        InputStream inputStream = this.stream.getInputStream();
        int next = inputStream.read();
        int i = 0;
        while (next != -1) {
            Assert.assertEquals((String)("@" + i), (long)INNER_MAIL.charAt(i++), (long)((char)next));
            next = inputStream.read();
        }
        Assert.assertEquals((long)(INNER_MAIL.length() - 2), (long)i);
    }

    @Test
    public void testSetNoRecurseSoInputStreamShouldContainInnerMail() throws Exception {
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_START_MULTIPART);
        this.nextIs(EntityState.T_PREAMBLE);
        this.nextShouldBeStandardPart(false);
        this.nextShouldBeStandardPart(true);
        this.stream.setRecursionMode(RecursionMode.M_NO_RECURSE);
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        InputStream inputStream = this.stream.getInputStream();
        int next = inputStream.read();
        int i = 0;
        while (next != -1) {
            Assert.assertEquals((String)("@" + i), (long)INNER_MAIL.charAt(i++), (long)((char)next));
            next = inputStream.read();
        }
        Assert.assertEquals((long)(INNER_MAIL.length() - 2), (long)i);
    }

    private void nextShouldBeStandardPart(boolean withHeader) throws Exception {
        this.nextIs(EntityState.T_START_BODYPART);
        this.nextIs(EntityState.T_START_HEADER);
        if (withHeader) {
            this.nextIs(EntityState.T_FIELD);
        }
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.nextIs(EntityState.T_END_BODYPART);
    }

    private void nextIs(EntityState state) throws Exception {
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)state), (Object)MimeTokenStream.stateToString((EntityState)this.stream.next()));
    }
}

