/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.common.geo.GeoJsonGeometryFormat;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.GeometryFormat;
import org.elasticsearch.common.geo.WKTGeometryFormat;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.MapXContentParser;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.StandardValidator;
import org.elasticsearch.geometry.utils.WellKnownText;

public final class GeometryParser {
    private final GeoJson geoJsonParser;
    private final WellKnownText wellKnownTextParser;
    private final boolean ignoreZValue;

    public GeometryParser(boolean rightOrientation, boolean coerce, boolean ignoreZValue) {
        StandardValidator validator = new StandardValidator(ignoreZValue);
        this.geoJsonParser = new GeoJson(rightOrientation, coerce, (GeometryValidator)validator);
        this.wellKnownTextParser = new WellKnownText(coerce, (GeometryValidator)validator);
        this.ignoreZValue = ignoreZValue;
    }

    public Geometry parse(XContentParser parser) throws IOException, ParseException {
        return this.geometryFormat(parser).fromXContent(parser);
    }

    public GeometryFormat<Geometry> geometryFormat(String format) {
        if (format.equals("geojson")) {
            return new GeoJsonGeometryFormat(this.geoJsonParser);
        }
        if (format.equals("wkt")) {
            return new WKTGeometryFormat(this.wellKnownTextParser);
        }
        throw new IllegalArgumentException("Unrecognized geometry format [" + format + "].");
    }

    public GeometryFormat<Geometry> geometryFormat(XContentParser parser) {
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return new GeoJsonGeometryFormat(this.geoJsonParser);
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return new WKTGeometryFormat(this.wellKnownTextParser);
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return new GeoJsonGeometryFormat(this.geoJsonParser);
        }
        throw new ElasticsearchParseException("shape must be an object consisting of type and coordinates", new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Geometry parseGeometry(Object value) throws ElasticsearchParseException {
        if (value instanceof List) {
            List values = (List)value;
            if (values.size() == 2 && values.get(0) instanceof Number) {
                GeoPoint point = GeoUtils.parseGeoPoint(values, this.ignoreZValue);
                return new Point(point.lon(), point.lat());
            }
            ArrayList<Geometry> geometries = new ArrayList<Geometry>(values.size());
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                geometries.add(this.parseGeometry(object));
            }
            return new GeometryCollection(geometries);
        }
        try (MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, Collections.singletonMap("null_value", value), null);){
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            if (this.isPoint(value)) {
                GeoPoint point = GeoUtils.parseGeoPoint((XContentParser)parser, new GeoPoint(), this.ignoreZValue);
                Point point2 = new Point(point.lon(), point.lat());
                return point2;
            }
            Geometry geometry = this.parse((XContentParser)parser);
            return geometry;
        }
        catch (IOException | ParseException ex) {
            throw new ElasticsearchParseException("error parsing geometry ", (Throwable)ex, new Object[0]);
        }
    }

    private boolean isPoint(Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.containsKey("lat") && map.containsKey("lon");
        }
        if (value instanceof String) {
            String string = (String)value;
            return Character.isDigit(string.charAt(0)) || string.indexOf(40) == -1;
        }
        return false;
    }
}

