/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaUsageValue;

public class QuotaCountUsage
implements QuotaUsageValue<QuotaCountUsage, QuotaCountLimit> {
    private final Long value;

    public static QuotaCountUsage count(long value) {
        return new QuotaCountUsage(value);
    }

    private QuotaCountUsage(Long value) {
        this.value = value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public QuotaCountUsage add(long additionalValue) {
        return new QuotaCountUsage(this.value + additionalValue);
    }

    @Override
    public QuotaCountUsage add(QuotaCountUsage additionalValue) {
        return new QuotaCountUsage(this.value + additionalValue.asLong());
    }

    @Override
    public boolean exceedLimit(QuotaCountLimit limit) {
        if (limit.isLimited()) {
            return this.value > limit.asLong();
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value.toString()).toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaCountUsage) {
            QuotaCountUsage that = (QuotaCountUsage)o;
            return Objects.equal((Object)this.value, (Object)that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }
}

