/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.webpush;

import com.google.crypto.tink.subtle.EllipticCurves;
import java.nio.charset.Charset;

final class WebPushConstants {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final int AUTH_SECRET_SIZE = 16;
    static final int IKM_SIZE = 32;
    static final int CEK_KEY_SIZE = 16;
    static final int NONCE_SIZE = 12;
    static final byte[] IKM_INFO = new byte[]{87, 101, 98, 80, 117, 115, 104, 58, 32, 105, 110, 102, 111, 0};
    static final byte[] CEK_INFO = new byte[]{67, 111, 110, 116, 101, 110, 116, 45, 69, 110, 99, 111, 100, 105, 110, 103, 58, 32, 97, 101, 115, 49, 50, 56, 103, 99, 109, 0};
    static final byte[] NONCE_INFO = new byte[]{67, 111, 110, 116, 101, 110, 116, 45, 69, 110, 99, 111, 100, 105, 110, 103, 58, 32, 110, 111, 110, 99, 101, 0};
    static final int SALT_SIZE = 16;
    static final int RECORD_SIZE_LEN = 4;
    static final int PUBLIC_KEY_SIZE_LEN = 1;
    static final int PUBLIC_KEY_SIZE = 65;
    static final int CONTENT_CODING_HEADER_SIZE = 86;
    static final byte PADDING_DELIMITER_BYTE = 2;
    static final int PADDING_DELIMETER_SIZE = 1;
    static final int DEFAULT_PADDING_SIZE = 0;
    static final int TAG_SIZE = 16;
    static final int CIPHERTEXT_OVERHEAD = 103;
    static final int MAX_CIPHERTEXT_SIZE = 4096;
    static final String HMAC_SHA256 = "HMACSHA256";
    static final EllipticCurves.PointFormatType UNCOMPRESSED_POINT_FORMAT = EllipticCurves.PointFormatType.UNCOMPRESSED;
    static final EllipticCurves.CurveType NIST_P256_CURVE_TYPE = EllipticCurves.CurveType.NIST_P256;

    private WebPushConstants() {
    }
}

