/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.fge.lambdas.Throwing;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.json.DTOModule;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.webadmin.service.DeleteMailsFromMailQueueTask;

public class WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String mailQueueName;
    private final String type;
    private final Optional<String> sender;
    private final Optional<String> name;
    private final Optional<String> recipient;
    private final long initialCount;
    private final long remainingCount;
    private final Instant timestamp;

    public static AdditionalInformationDTOModule<DeleteMailsFromMailQueueTask.AdditionalInformation, WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(DeleteMailsFromMailQueueTask.AdditionalInformation.class).convertToDTO(WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO.class).toDomainObjectConverter(WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO::fromDTO).toDTOConverter(WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO::toDTO).typeName(DeleteMailsFromMailQueueTask.TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    private static WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO toDTO(DeleteMailsFromMailQueueTask.AdditionalInformation domainObject, String typeName) {
        return new WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO(typeName, domainObject.getMailQueueName(), domainObject.getSender(), domainObject.getName(), domainObject.getRecipient(), domainObject.getInitialCount(), domainObject.getRemainingCount(), domainObject.timestamp());
    }

    private static DeleteMailsFromMailQueueTask.AdditionalInformation fromDTO(WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO dto) {
        return new DeleteMailsFromMailQueueTask.AdditionalInformation(MailQueueName.of((String)dto.getMailQueueName()), dto.getInitialCount(), dto.getRemainingCount(), dto.sender.map(Throwing.function(MailAddress::new).sneakyThrow()), dto.name, dto.recipient.map(Throwing.function(MailAddress::new).sneakyThrow()), dto.timestamp);
    }

    public WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="mailQueueName") String mailQueueName, @JsonProperty(value="sender") Optional<String> sender, @JsonProperty(value="name") Optional<String> name, @JsonProperty(value="recipient") Optional<String> recipient, @JsonProperty(value="initialCount") long initialCount, @JsonProperty(value="remainingCount") long remainingCount, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.mailQueueName = mailQueueName;
        this.sender = sender;
        this.name = name;
        this.recipient = recipient;
        this.initialCount = initialCount;
        this.remainingCount = remainingCount;
        this.timestamp = timestamp;
    }

    public String getMailQueueName() {
        return this.mailQueueName;
    }

    public Optional<String> getSender() {
        return this.sender;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getRecipient() {
        return this.recipient;
    }

    public long getInitialCount() {
        return this.initialCount;
    }

    public long getRemainingCount() {
        return this.remainingCount;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }
}

