/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message.request;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.request.DayMonthYear;

public final class SearchKey {
    private static final SearchKey UNSEEN = new SearchKey(Type.TYPE_UNSEEN, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey UNFLAGGED = new SearchKey(Type.TYPE_UNFLAGGED, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey UNDRAFT = new SearchKey(Type.TYPE_UNDRAFT, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey UNDELETED = new SearchKey(Type.TYPE_UNDELETED, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey UNANSWERED = new SearchKey(Type.TYPE_UNANSWERED, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey SEEN = new SearchKey(Type.TYPE_SEEN, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey RECENT = new SearchKey(Type.TYPE_RECENT, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey OLD = new SearchKey(Type.TYPE_OLD, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey NEW = new SearchKey(Type.TYPE_NEW, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey FLAGGED = new SearchKey(Type.TYPE_FLAGGED, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey DRAFT = new SearchKey(Type.TYPE_DRAFT, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey DELETED = new SearchKey(Type.TYPE_DELETED, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey ANSWERED = new SearchKey(Type.TYPE_ANSWERED, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private static final SearchKey ALL = new SearchKey(Type.TYPE_ALL, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    private final Type type;
    private final DayMonthYear date;
    private final List<SearchKey> keys;
    private final long size;
    private final String name;
    private final String value;
    private final IdRange[] sequence;
    private final UidRange[] uids;
    private final long seconds;
    private final long modSeq;
    private final String threadId;
    private final String messageId;

    public static SearchKey buildSequenceSet(IdRange[] ids) {
        return new SearchKey(Type.TYPE_SEQUENCE_SET, null, null, 0L, null, null, null, ids, -1L, -1L, null, null);
    }

    public static SearchKey buildUidSet(UidRange[] ids) {
        return new SearchKey(Type.TYPE_UID, null, null, 0L, null, null, ids, null, -1L, -1L, null, null);
    }

    public static SearchKey buildAll() {
        return ALL;
    }

    public static SearchKey buildAnswered() {
        return ANSWERED;
    }

    public static SearchKey buildDeleted() {
        return DELETED;
    }

    public static SearchKey buildDraft() {
        return DRAFT;
    }

    public static SearchKey buildFlagged() {
        return FLAGGED;
    }

    public static SearchKey buildNew() {
        return NEW;
    }

    public static SearchKey buildOld() {
        return OLD;
    }

    public static SearchKey buildRecent() {
        return RECENT;
    }

    public static SearchKey buildSeen() {
        return SEEN;
    }

    public static SearchKey buildUnanswered() {
        return UNANSWERED;
    }

    public static SearchKey buildUndeleted() {
        return UNDELETED;
    }

    public static SearchKey buildUndraft() {
        return UNDRAFT;
    }

    public static SearchKey buildUnflagged() {
        return UNFLAGGED;
    }

    public static SearchKey buildUnseen() {
        return UNSEEN;
    }

    public static SearchKey buildBcc(String value) {
        return new SearchKey(Type.TYPE_BCC, null, null, 0L, null, value, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildBody(String value) {
        return new SearchKey(Type.TYPE_BODY, null, null, 0L, null, value, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildCc(String value) {
        return new SearchKey(Type.TYPE_CC, null, null, 0L, null, value, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildFrom(String value) {
        return new SearchKey(Type.TYPE_FROM, null, null, 0L, null, value, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildKeyword(String value) {
        return new SearchKey(Type.TYPE_KEYWORD, null, null, 0L, null, value, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildSubject(String value) {
        return new SearchKey(Type.TYPE_SUBJECT, null, null, 0L, null, value, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildText(String value) {
        return new SearchKey(Type.TYPE_TEXT, null, null, 0L, null, value, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildTo(String value) {
        return new SearchKey(Type.TYPE_TO, null, null, 0L, null, value, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildThreadId(String value) {
        return new SearchKey(Type.TYPE_THREADID, null, null, 0L, null, null, null, null, -1L, -1L, value, null);
    }

    public static SearchKey buildMessageId(String value) {
        return new SearchKey(Type.TYPE_EMAILID, null, null, 0L, null, null, null, null, -1L, -1L, null, value);
    }

    public static SearchKey buildUnkeyword(String value) {
        return new SearchKey(Type.TYPE_UNKEYWORD, null, null, 0L, null, value, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildYounger(long seconds) {
        return new SearchKey(Type.TYPE_YOUNGER, null, null, 0L, null, null, null, null, seconds, -1L, null, null);
    }

    public static SearchKey buildOlder(long seconds) {
        return new SearchKey(Type.TYPE_OLDER, null, null, 0L, null, null, null, null, seconds, -1L, null, null);
    }

    public static SearchKey buildBefore(DayMonthYear date) {
        return new SearchKey(Type.TYPE_BEFORE, date, null, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildOn(DayMonthYear date) {
        return new SearchKey(Type.TYPE_ON, date, null, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildSavedOn(DayMonthYear date) {
        return new SearchKey(Type.TYPE_SAVEDON, date, null, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildSentBefore(DayMonthYear date) {
        return new SearchKey(Type.TYPE_SENTBEFORE, date, null, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildSavedBefore(DayMonthYear date) {
        return new SearchKey(Type.TYPE_SAVEDBEFORE, date, null, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildSentOn(DayMonthYear date) {
        return new SearchKey(Type.TYPE_SENTON, date, null, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildSentSince(DayMonthYear date) {
        return new SearchKey(Type.TYPE_SENTSINCE, date, null, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildSince(DayMonthYear date) {
        return new SearchKey(Type.TYPE_SINCE, date, null, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildSavedSince(DayMonthYear date) {
        return new SearchKey(Type.TYPE_SAVEDSINCE, date, null, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildSaveDateSupported() {
        return new SearchKey(Type.TYPE_SAVEDATESUPPORTED, null, null, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildHeader(String name, String value) {
        return new SearchKey(Type.TYPE_HEADER, null, null, 0L, name, value, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildLarger(long size) {
        return new SearchKey(Type.TYPE_LARGER, null, null, size, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildSmaller(long size) {
        return new SearchKey(Type.TYPE_SMALLER, null, null, size, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildNot(SearchKey key) {
        ArrayList<SearchKey> keys = new ArrayList<SearchKey>();
        keys.add(key);
        return new SearchKey(Type.TYPE_NOT, null, keys, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildOr(SearchKey keyOne, SearchKey keyTwo) {
        ArrayList<SearchKey> keys = new ArrayList<SearchKey>();
        keys.add(keyOne);
        keys.add(keyTwo);
        return new SearchKey(Type.TYPE_OR, null, keys, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildAnd(List<SearchKey> keys) {
        return new SearchKey(Type.TYPE_AND, null, keys, 0L, null, null, null, null, -1L, -1L, null, null);
    }

    public static SearchKey buildModSeq(long modSeq) {
        return new SearchKey(Type.TYPE_MODSEQ, null, null, 0L, null, null, null, null, -1L, modSeq, null, null);
    }

    private SearchKey(Type type, DayMonthYear date, List<SearchKey> keys, long number, String name, String value, UidRange[] uids, IdRange[] sequence, long seconds, long modSeq, String threadId, String messageId) {
        this.type = type;
        this.date = date;
        this.keys = keys;
        this.size = number;
        this.name = name;
        this.value = value;
        this.seconds = seconds;
        this.modSeq = modSeq;
        this.uids = uids;
        this.sequence = sequence;
        this.threadId = threadId;
        this.messageId = messageId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public DayMonthYear getDate() {
        return this.date;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public IdRange[] getSequenceNumbers() {
        return this.sequence;
    }

    public UidRange[] getUidRanges() {
        return this.uids;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public List<SearchKey> getKeys() {
        return this.keys;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public long getModSeq() {
        return this.modSeq;
    }

    public final boolean equals(Object o) {
        if (o instanceof SearchKey) {
            SearchKey searchKey = (SearchKey)o;
            return Objects.equals((Object)this.type, (Object)searchKey.type) && Objects.equals(this.size, searchKey.size) && Objects.equals(this.seconds, searchKey.seconds) && Objects.equals(this.modSeq, searchKey.modSeq) && Objects.equals(this.date, searchKey.date) && Objects.equals(this.keys, searchKey.keys) && Objects.equals(this.name, searchKey.name) && Objects.equals(this.value, searchKey.value) && Arrays.equals(this.sequence, searchKey.sequence) && Arrays.equals(this.uids, searchKey.uids) && Objects.equals(this.threadId, searchKey.threadId) && Objects.equals(this.messageId, searchKey.messageId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.type, this.date, this.keys, this.size, this.name, this.value, Arrays.hashCode(this.sequence), Arrays.hashCode(this.uids), this.seconds, this.modSeq, this.threadId, this.messageId});
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).omitNullValues();
        if (this.modSeq >= 0L) {
            toStringHelper.add("modSeq", this.modSeq);
        }
        if (this.size > 0L) {
            toStringHelper.add("size", this.size);
        }
        if (this.seconds > 0L) {
            toStringHelper.add("seconds", this.seconds);
        }
        return toStringHelper.add("type", (Object)this.type).add("date", (Object)this.date).add("value", (Object)this.value).add("uids", Optional.ofNullable(this.uids).map(ImmutableList::copyOf).orElse(null)).add("sequences", Optional.ofNullable(this.sequence).map(ImmutableList::copyOf).orElse(null)).add("keys", Optional.ofNullable(this.keys).map(ImmutableList::copyOf).orElse(null)).add("threadId", (Object)this.threadId).add("messageId", (Object)this.messageId).toString();
    }

    public static enum Type {
        TYPE_SEQUENCE_SET,
        TYPE_UID,
        TYPE_ALL,
        TYPE_ANSWERED,
        TYPE_DELETED,
        TYPE_DRAFT,
        TYPE_FLAGGED,
        TYPE_NEW,
        TYPE_OLD,
        TYPE_RECENT,
        TYPE_SEEN,
        TYPE_UNANSWERED,
        TYPE_UNDELETED,
        TYPE_UNDRAFT,
        TYPE_UNFLAGGED,
        TYPE_UNSEEN,
        TYPE_BCC,
        TYPE_BODY,
        TYPE_CC,
        TYPE_FROM,
        TYPE_KEYWORD,
        TYPE_SUBJECT,
        TYPE_TEXT,
        TYPE_TO,
        TYPE_UNKEYWORD,
        TYPE_BEFORE,
        TYPE_ON,
        TYPE_SENTBEFORE,
        TYPE_SENTON,
        TYPE_SENTSINCE,
        TYPE_SINCE,
        TYPE_HEADER,
        TYPE_LARGER,
        TYPE_SMALLER,
        TYPE_NOT,
        TYPE_OR,
        TYPE_AND,
        TYPE_YOUNGER,
        TYPE_OLDER,
        TYPE_MODSEQ,
        TYPE_THREADID,
        TYPE_EMAILID,
        TYPE_SAVEDBEFORE,
        TYPE_SAVEDON,
        TYPE_SAVEDSINCE,
        TYPE_SAVEDATESUPPORTED;

    }
}

