/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.cluster.stats.ClusterJvmMemory;
import org.opensearch.client.opensearch.cluster.stats.ClusterJvmVersion;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ClusterJvm
implements JsonpSerializable {
    private final long maxUptimeInMillis;
    private final ClusterJvmMemory mem;
    private final long threads;
    private final List<ClusterJvmVersion> versions;
    public static final JsonpDeserializer<ClusterJvm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterJvm::setupClusterJvmDeserializer);

    private ClusterJvm(Builder builder) {
        this.maxUptimeInMillis = ApiTypeHelper.requireNonNull(builder.maxUptimeInMillis, this, "maxUptimeInMillis");
        this.mem = ApiTypeHelper.requireNonNull(builder.mem, this, "mem");
        this.threads = ApiTypeHelper.requireNonNull(builder.threads, this, "threads");
        this.versions = ApiTypeHelper.unmodifiableRequired(builder.versions, (Object)this, "versions");
    }

    public static ClusterJvm of(Function<Builder, ObjectBuilder<ClusterJvm>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long maxUptimeInMillis() {
        return this.maxUptimeInMillis;
    }

    public final ClusterJvmMemory mem() {
        return this.mem;
    }

    public final long threads() {
        return this.threads;
    }

    public final List<ClusterJvmVersion> versions() {
        return this.versions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_uptime_in_millis");
        generator.write(this.maxUptimeInMillis);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("threads");
        generator.write(this.threads);
        if (ApiTypeHelper.isDefined(this.versions)) {
            generator.writeKey("versions");
            generator.writeStartArray();
            for (ClusterJvmVersion item0 : this.versions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupClusterJvmDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxUptimeInMillis, JsonpDeserializer.longDeserializer(), "max_uptime_in_millis");
        op.add(Builder::mem, ClusterJvmMemory._DESERIALIZER, "mem");
        op.add(Builder::threads, JsonpDeserializer.longDeserializer(), "threads");
        op.add(Builder::versions, JsonpDeserializer.arrayDeserializer(ClusterJvmVersion._DESERIALIZER), "versions");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterJvm> {
        private Long maxUptimeInMillis;
        private ClusterJvmMemory mem;
        private Long threads;
        private List<ClusterJvmVersion> versions;

        public final Builder maxUptimeInMillis(long value) {
            this.maxUptimeInMillis = value;
            return this;
        }

        public final Builder mem(ClusterJvmMemory value) {
            this.mem = value;
            return this;
        }

        public final Builder mem(Function<ClusterJvmMemory.Builder, ObjectBuilder<ClusterJvmMemory>> fn) {
            return this.mem(fn.apply(new ClusterJvmMemory.Builder()).build());
        }

        public final Builder threads(long value) {
            this.threads = value;
            return this;
        }

        public final Builder versions(List<ClusterJvmVersion> list) {
            this.versions = Builder._listAddAll(this.versions, list);
            return this;
        }

        public final Builder versions(ClusterJvmVersion value, ClusterJvmVersion ... values) {
            this.versions = Builder._listAdd(this.versions, value, values);
            return this;
        }

        public final Builder versions(Function<ClusterJvmVersion.Builder, ObjectBuilder<ClusterJvmVersion>> fn) {
            return this.versions(fn.apply(new ClusterJvmVersion.Builder()).build(), new ClusterJvmVersion[0]);
        }

        @Override
        public ClusterJvm build() {
            this._checkSingleUse();
            return new ClusterJvm(this);
        }
    }
}

