/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class TopHitsAggregate
extends AggregateBase
implements AggregateVariant {
    private final HitsMetadata<JsonData> hits;
    public static final JsonpDeserializer<TopHitsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TopHitsAggregate::setupTopHitsAggregateDeserializer);

    private TopHitsAggregate(Builder builder) {
        super(builder);
        this.hits = ApiTypeHelper.requireNonNull(builder.hits, this, "hits");
    }

    public static TopHitsAggregate of(Function<Builder, ObjectBuilder<TopHitsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.TopHits;
    }

    public final HitsMetadata<JsonData> hits() {
        return this.hits;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
    }

    protected static void setupTopHitsAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(Builder::hits, HitsMetadata.createHitsMetadataDeserializer(JsonData._DESERIALIZER), "hits");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TopHitsAggregate> {
        private HitsMetadata<JsonData> hits;

        public final Builder hits(HitsMetadata<JsonData> value) {
            this.hits = value;
            return this;
        }

        public final Builder hits(Function<HitsMetadata.Builder<JsonData>, ObjectBuilder<HitsMetadata<JsonData>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TopHitsAggregate build() {
            this._checkSingleUse();
            return new TopHitsAggregate(this);
        }
    }
}

