/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.datastax.oss.driver.api.core.CqlSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.io.FileNotFoundException;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.init.CassandraZonedDateTimeModule;
import org.apache.james.backends.cassandra.init.KeyspaceFactory;
import org.apache.james.backends.cassandra.init.ResilientClusterProvider;
import org.apache.james.backends.cassandra.init.SessionWithInitializedTablesFactory;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.ClusterConfiguration;
import org.apache.james.backends.cassandra.init.configuration.KeyspaceConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraHealthCheck;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionDAO;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionModule;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.modules.mailbox.CassandraSchemaVersionStartUpCheck;
import org.apache.james.modules.mailbox.KeyspacesConfiguration;
import org.apache.james.server.CassandraProbe;
import org.apache.james.util.Host;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraSessionModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraSessionModule.class);
    private static final String LOCALHOST = "127.0.0.1";
    private static final String BATCHSIZES_FILE_NAME = "batchsizes";
    private static final String CASSANDRA_FILE_NAME = "cassandra";
    private static final int CASSANDRA_PORT = 9042;

    protected void configure() {
        this.bind(InitializedCluster.class).in(Scopes.SINGLETON);
        this.bind(CqlSession.class).toProvider(SessionWithInitializedTablesFactory.class);
        Multibinder cassandraDataDefinitions = Multibinder.newSetBinder((Binder)this.binder(), CassandraModule.class);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraZonedDateTimeModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraSchemaVersionModule.MODULE);
        this.bind(CassandraSchemaVersionManager.class).in(Scopes.SINGLETON);
        this.bind(CassandraSchemaVersionDAO.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), StartUpCheck.class).addBinding().to(CassandraSchemaVersionStartUpCheck.class);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(CassandraProbe.class);
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(CassandraHealthCheck.class);
    }

    @Singleton
    @Provides
    SessionWithInitializedTablesFactory provideSessionFactory(InitializedCluster cluster, CassandraModule module) {
        return new SessionWithInitializedTablesFactory(cluster.cluster, module);
    }

    @Provides
    @Singleton
    CassandraModule composeDataDefinitions(Set<CassandraModule> modules) {
        return CassandraModule.aggregateModules(modules);
    }

    @Provides
    @Singleton
    BatchSizes getBatchSizesConfiguration(PropertiesProvider propertiesProvider) {
        try {
            Configuration configuration = propertiesProvider.getConfiguration(BATCHSIZES_FILE_NAME);
            BatchSizes batchSizes = BatchSizes.builder().fetchMetadata(configuration.getInt("fetch.metadata", 200)).fetchHeaders(configuration.getInt("fetch.headers", 200)).fetchFull(configuration.getInt("fetch.full", 200)).copyBatchSize(configuration.getInt("copy", 200)).moveBatchSize(configuration.getInt("move", 200)).build();
            LOGGER.debug("BatchSize configuration: {}", (Object)batchSizes);
            return batchSizes;
        }
        catch (FileNotFoundException | ConfigurationException e) {
            LOGGER.info("Could not locate batchsizes configuration file. Using default values.");
            return BatchSizes.defaultValues();
        }
    }

    @Provides
    @Singleton
    @VisibleForTesting
    CassandraConfiguration provideCassandraConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            return CassandraConfiguration.from((Configuration)propertiesProvider.getConfiguration(CASSANDRA_FILE_NAME));
        }
        catch (FileNotFoundException e) {
            return CassandraConfiguration.DEFAULT_CONFIGURATION;
        }
    }

    @Provides
    @Singleton
    ClusterConfiguration provideClusterConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            return ClusterConfiguration.from((Configuration)propertiesProvider.getConfiguration(CASSANDRA_FILE_NAME));
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not locate cassandra configuration file. Defaulting to node 127.0.0.1:9042");
            return ClusterConfiguration.builder().host(Host.from((String)LOCALHOST, (int)9042)).build();
        }
    }

    @Provides
    @Singleton
    KeyspacesConfiguration provideKeyspacesConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            return KeyspacesConfiguration.from(propertiesProvider.getConfiguration(CASSANDRA_FILE_NAME));
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not locate cassandra configuration file. Using default keyspaces configuration instead");
            return KeyspacesConfiguration.builder().build();
        }
    }

    @Provides
    @Singleton
    KeyspaceConfiguration provideMainKeyspaceConfiguration(KeyspacesConfiguration keyspacesConfiguration) {
        return keyspacesConfiguration.mainKeyspaceConfiguration();
    }

    static class InitializedCluster {
        private final CqlSession cluster;

        @Inject
        private InitializedCluster(ResilientClusterProvider sessionProvider, ClusterConfiguration clusterConfiguration, KeyspacesConfiguration keyspacesConfiguration) {
            this.cluster = sessionProvider.get();
            if (clusterConfiguration.shouldCreateKeyspace()) {
                KeyspaceFactory.createKeyspace((KeyspaceConfiguration)keyspacesConfiguration.mainKeyspaceConfiguration(), (CqlSession)this.cluster).block();
            }
        }
    }
}

