/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.IcuCollationAlternate;
import org.opensearch.client.opensearch._types.analysis.IcuCollationCaseFirst;
import org.opensearch.client.opensearch._types.analysis.IcuCollationDecomposition;
import org.opensearch.client.opensearch._types.analysis.IcuCollationStrength;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class IcuCollationTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final IcuCollationAlternate alternate;
    private final IcuCollationCaseFirst casefirst;
    private final boolean caselevel;
    private final String country;
    private final IcuCollationDecomposition decomposition;
    private final boolean hiraganaquaternarymode;
    private final String language;
    private final boolean numeric;
    private final IcuCollationStrength strength;
    @Nullable
    private final String variabletop;
    private final String variant;
    public static final JsonpDeserializer<IcuCollationTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuCollationTokenFilter::setupIcuCollationTokenFilterDeserializer);

    private IcuCollationTokenFilter(Builder builder) {
        super(builder);
        this.alternate = ApiTypeHelper.requireNonNull(builder.alternate, this, "alternate");
        this.casefirst = ApiTypeHelper.requireNonNull(builder.casefirst, this, "casefirst");
        this.caselevel = ApiTypeHelper.requireNonNull(builder.caselevel, this, "caselevel");
        this.country = ApiTypeHelper.requireNonNull(builder.country, this, "country");
        this.decomposition = ApiTypeHelper.requireNonNull(builder.decomposition, this, "decomposition");
        this.hiraganaquaternarymode = ApiTypeHelper.requireNonNull(builder.hiraganaquaternarymode, this, "hiraganaquaternarymode");
        this.language = ApiTypeHelper.requireNonNull(builder.language, this, "language");
        this.numeric = ApiTypeHelper.requireNonNull(builder.numeric, this, "numeric");
        this.strength = ApiTypeHelper.requireNonNull(builder.strength, this, "strength");
        this.variabletop = builder.variabletop;
        this.variant = ApiTypeHelper.requireNonNull(builder.variant, this, "variant");
    }

    public static IcuCollationTokenFilter of(Function<Builder, ObjectBuilder<IcuCollationTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.IcuCollation;
    }

    public final IcuCollationAlternate alternate() {
        return this.alternate;
    }

    public final IcuCollationCaseFirst casefirst() {
        return this.casefirst;
    }

    public final boolean caselevel() {
        return this.caselevel;
    }

    public final String country() {
        return this.country;
    }

    public final IcuCollationDecomposition decomposition() {
        return this.decomposition;
    }

    public final boolean hiraganaquaternarymode() {
        return this.hiraganaquaternarymode;
    }

    public final String language() {
        return this.language;
    }

    public final boolean numeric() {
        return this.numeric;
    }

    public final IcuCollationStrength strength() {
        return this.strength;
    }

    @Nullable
    public final String variabletop() {
        return this.variabletop;
    }

    public final String variant() {
        return this.variant;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_collation");
        super.serializeInternal(generator, mapper);
        generator.writeKey("alternate");
        this.alternate.serialize(generator, mapper);
        generator.writeKey("caseFirst");
        this.casefirst.serialize(generator, mapper);
        generator.writeKey("caseLevel");
        generator.write(this.caselevel);
        generator.writeKey("country");
        generator.write(this.country);
        generator.writeKey("decomposition");
        this.decomposition.serialize(generator, mapper);
        generator.writeKey("hiraganaQuaternaryMode");
        generator.write(this.hiraganaquaternarymode);
        generator.writeKey("language");
        generator.write(this.language);
        generator.writeKey("numeric");
        generator.write(this.numeric);
        generator.writeKey("strength");
        this.strength.serialize(generator, mapper);
        if (this.variabletop != null) {
            generator.writeKey("variableTop");
            generator.write(this.variabletop);
        }
        generator.writeKey("variant");
        generator.write(this.variant);
    }

    protected static void setupIcuCollationTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::alternate, IcuCollationAlternate._DESERIALIZER, "alternate");
        op.add(Builder::casefirst, IcuCollationCaseFirst._DESERIALIZER, "caseFirst");
        op.add(Builder::caselevel, JsonpDeserializer.booleanDeserializer(), "caseLevel");
        op.add(Builder::country, JsonpDeserializer.stringDeserializer(), "country");
        op.add(Builder::decomposition, IcuCollationDecomposition._DESERIALIZER, "decomposition");
        op.add(Builder::hiraganaquaternarymode, JsonpDeserializer.booleanDeserializer(), "hiraganaQuaternaryMode");
        op.add(Builder::language, JsonpDeserializer.stringDeserializer(), "language");
        op.add(Builder::numeric, JsonpDeserializer.booleanDeserializer(), "numeric");
        op.add(Builder::strength, IcuCollationStrength._DESERIALIZER, "strength");
        op.add(Builder::variabletop, JsonpDeserializer.stringDeserializer(), "variableTop");
        op.add(Builder::variant, JsonpDeserializer.stringDeserializer(), "variant");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IcuCollationTokenFilter> {
        private IcuCollationAlternate alternate;
        private IcuCollationCaseFirst casefirst;
        private Boolean caselevel;
        private String country;
        private IcuCollationDecomposition decomposition;
        private Boolean hiraganaquaternarymode;
        private String language;
        private Boolean numeric;
        private IcuCollationStrength strength;
        @Nullable
        private String variabletop;
        private String variant;

        public final Builder alternate(IcuCollationAlternate value) {
            this.alternate = value;
            return this;
        }

        public final Builder casefirst(IcuCollationCaseFirst value) {
            this.casefirst = value;
            return this;
        }

        public final Builder caselevel(boolean value) {
            this.caselevel = value;
            return this;
        }

        public final Builder country(String value) {
            this.country = value;
            return this;
        }

        public final Builder decomposition(IcuCollationDecomposition value) {
            this.decomposition = value;
            return this;
        }

        public final Builder hiraganaquaternarymode(boolean value) {
            this.hiraganaquaternarymode = value;
            return this;
        }

        public final Builder language(String value) {
            this.language = value;
            return this;
        }

        public final Builder numeric(boolean value) {
            this.numeric = value;
            return this;
        }

        public final Builder strength(IcuCollationStrength value) {
            this.strength = value;
            return this;
        }

        public final Builder variabletop(@Nullable String value) {
            this.variabletop = value;
            return this;
        }

        public final Builder variant(String value) {
            this.variant = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IcuCollationTokenFilter build() {
            this._checkSingleUse();
            return new IcuCollationTokenFilter(this);
        }
    }
}

