/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.opensearch;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.backends.opensearch.AliasName;
import org.apache.james.backends.opensearch.DeleteByQueryPerformer;
import org.apache.james.backends.opensearch.DocumentId;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.backends.opensearch.RoutingKey;
import org.apache.james.backends.opensearch.UpdatedRepresentation;
import org.apache.james.backends.opensearch.WriteAliasName;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.bulk.DeleteOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OpenSearchIndexer {
    private static final int DEBUG_MAX_LENGTH_CONTENT = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchIndexer.class);
    private final ReactorOpenSearchClient client;
    private final AliasName aliasName;
    private final DeleteByQueryPerformer deleteByQueryPerformer;

    public OpenSearchIndexer(ReactorOpenSearchClient client, WriteAliasName aliasName) {
        this.client = client;
        this.deleteByQueryPerformer = new DeleteByQueryPerformer(client, aliasName);
        this.aliasName = aliasName;
    }

    public Mono<IndexResponse> index(DocumentId id, String content, RoutingKey routingKey) {
        this.checkArgument(content);
        this.logContent(id, content);
        try {
            return this.client.index(new IndexRequest.Builder().index(this.aliasName.getValue()).id(id.asString()).document((Object)new RawValue(content)).routing(routingKey.asString()).build());
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    private void logContent(DocumentId id, String content) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Indexing {}: {}", (Object)id.asString(), (Object)StringUtils.left((String)content, (int)1000));
        }
    }

    public Mono<BulkResponse> update(List<UpdatedRepresentation> updatedDocumentParts, RoutingKey routingKey) {
        Preconditions.checkNotNull(updatedDocumentParts);
        Preconditions.checkNotNull((Object)routingKey);
        if (updatedDocumentParts.isEmpty()) {
            return Mono.empty();
        }
        BulkRequest.Builder bulkBuilder = new BulkRequest.Builder();
        updatedDocumentParts.forEach(updatedDocumentPart -> bulkBuilder.operations(op -> op.update(idx -> (ObjectBuilder)((UpdateOperation.Builder)((UpdateOperation.Builder)idx.index(this.aliasName.getValue())).id(updatedDocumentPart.getId().asString())).document(Collections.singletonMap("doc", new RawValue(updatedDocumentPart.getUpdatedDocumentPart()))).routing(routingKey.asString()))));
        try {
            return this.client.bulk(bulkBuilder.build());
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    public Mono<BulkResponse> delete(List<DocumentId> ids, RoutingKey routingKey) {
        if (ids.isEmpty()) {
            return Mono.empty();
        }
        BulkRequest.Builder bulkBuilder = new BulkRequest.Builder();
        ids.forEach(id -> bulkBuilder.operations(op -> op.delete(idx -> (ObjectBuilder)((DeleteOperation.Builder)((DeleteOperation.Builder)idx.index(this.aliasName.getValue())).id(id.asString())).routing(routingKey.asString()))));
        try {
            return this.client.bulk(bulkBuilder.build());
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    public Mono<Void> deleteAllMatchingQuery(Query query, RoutingKey routingKey) {
        return this.deleteByQueryPerformer.perform(query, routingKey);
    }

    private void checkArgument(String content) {
        Preconditions.checkArgument((content != null ? 1 : 0) != 0, (Object)"content should be provided");
    }

    public Mono<GetResponse<ObjectNode>> get(DocumentId id, RoutingKey routingKey) {
        try {
            return Mono.fromRunnable(() -> {
                Preconditions.checkNotNull((Object)id);
                Preconditions.checkNotNull((Object)routingKey);
            }).then(this.client.get(new GetRequest.Builder().index(this.aliasName.getValue()).id(id.asString()).routing(routingKey.asString()).build()));
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }
}

