/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.james.transport.mailets.ReplacingPattern;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.StringUtils;

public class PatternExtractor {
    private static final int PATTERN = 0;
    private static final int SUBSTITUTION = 1;
    private static final int OPTIONS = 2;

    public List<ReplacingPattern> getPatternsFromString(String pattern) throws MailetException {
        String trimPattern = pattern.trim();
        this.assertPatternSurroundedWithSlashes(trimPattern);
        ImmutableList.Builder patternList = ImmutableList.builder();
        for (String aPatternArray : this.extractPatternParts(trimPattern)) {
            patternList.add((Object)this.stripSurroundingSlashes(aPatternArray));
        }
        return patternList.build();
    }

    private void assertPatternSurroundedWithSlashes(String pattern) throws MailetException {
        if (pattern.length() < 2 || !pattern.startsWith("/") && !pattern.endsWith("/")) {
            throw new MailetException("Invalid expression: " + pattern);
        }
    }

    private String[] extractPatternParts(String trimPattern) {
        String trimSurroundingSlashes = trimPattern.substring(1, trimPattern.length() - 1);
        return StringUtils.split((String)trimSurroundingSlashes, (String)"/,/");
    }

    private ReplacingPattern stripSurroundingSlashes(String line) throws MailetException {
        String[] parts = StringUtils.split((String)line, (String)"/");
        if (parts.length < 3) {
            throw new MailetException("Invalid expression: " + line);
        }
        return new ReplacingPattern(Pattern.compile(parts[0], this.extractOptions(parts[2])), this.extractRepeat(parts[2]), this.unescapeSubstitutions(parts[1]));
    }

    private int extractOptions(String optionsAsString) {
        int options = 0;
        if (optionsAsString.contains("i")) {
            options |= 2;
        }
        if (optionsAsString.contains("m")) {
            options |= 8;
        }
        if (optionsAsString.contains("s")) {
            options |= 0x20;
        }
        return options;
    }

    private boolean extractRepeat(String flagsAsString) {
        return flagsAsString.contains("r");
    }

    private String unescapeSubstitutions(String substitutions) {
        String unescaped = substitutions;
        if (unescaped.contains("\\r")) {
            unescaped = unescaped.replaceAll("\\\\r", "\r");
        }
        if (unescaped.contains("\\n")) {
            unescaped = unescaped.replaceAll("\\\\n", "\n");
        }
        if (unescaped.contains("\\t")) {
            unescaped = unescaped.replaceAll("\\\\t", "\t");
        }
        return unescaped;
    }

    public List<ReplacingPattern> getPatternsFromFileList(String filepar) throws MailetException, IOException {
        ImmutableList.Builder patternList = ImmutableList.builder();
        for (String file : Splitter.on((String)",").split((CharSequence)filepar)) {
            FileNameWithCharset fileNameWithCharset = FileNameWithCharset.from(file);
            Optional<? extends InputStream> inputStream = this.retrieveInputStream(fileNameWithCharset.getFileName());
            if (!inputStream.isPresent()) continue;
            patternList.addAll(this.getPatternsFromStream(inputStream.get(), fileNameWithCharset.getCharset()));
        }
        return patternList.build();
    }

    private List<ReplacingPattern> getPatternsFromStream(InputStream stream, Charset charset) throws MailetException, IOException {
        ImmutableList.Builder patternList = ImmutableList.builder();
        for (String line : IOUtils.readLines((InputStream)stream, (Charset)charset)) {
            if (this.isComment(line = line.trim())) continue;
            this.assertPatternSurroundedWithSlashes(line);
            patternList.add((Object)this.stripSurroundingSlashes(line.substring(1, line.length() - 1)));
        }
        return patternList.build();
    }

    private boolean isComment(String line) {
        return Strings.isNullOrEmpty((String)line) || line.startsWith("#");
    }

    private Optional<? extends InputStream> retrieveInputStream(String fileAsString) throws FileNotFoundException {
        if (fileAsString.startsWith("#")) {
            return Optional.of(this.getClass().getResourceAsStream(fileAsString.substring(1)));
        }
        File file = new File(fileAsString);
        if (file.isFile()) {
            return Optional.of(new FileInputStream(file));
        }
        return Optional.empty();
    }

    private static class FileNameWithCharset {
        private final String fileName;
        private final Charset charset;

        public static FileNameWithCharset from(String fileName) {
            Optional<Integer> charsetOffset = FileNameWithCharset.charsetIndex(fileName);
            if (charsetOffset.isPresent()) {
                return new FileNameWithCharset(fileName.substring(0, charsetOffset.get()), FileNameWithCharset.charset(fileName, charsetOffset.get()));
            }
            return new FileNameWithCharset(fileName, null);
        }

        private static Optional<Integer> charsetIndex(String fileName) {
            int charsetOffset = fileName.lastIndexOf(63);
            if (charsetOffset >= 0) {
                return Optional.of(charsetOffset);
            }
            return Optional.empty();
        }

        private static Charset charset(String fileName, int charsetOffset) {
            return Charset.forName(fileName.substring(charsetOffset + 1));
        }

        private FileNameWithCharset(String fileName, Charset charset) {
            this.fileName = fileName;
            this.charset = charset;
        }

        public String getFileName() {
            return this.fileName;
        }

        public Charset getCharset() {
            return this.charset;
        }
    }
}

