/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.cluster.stats.FieldTypes;
import org.opensearch.client.opensearch.cluster.stats.RuntimeFieldTypes;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class FieldTypesMappings
implements PlainJsonSerializable {
    private final List<FieldTypes> fieldTypes;
    private final List<RuntimeFieldTypes> runtimeFieldTypes;
    public static final JsonpDeserializer<FieldTypesMappings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldTypesMappings::setupFieldTypesMappingsDeserializer);

    private FieldTypesMappings(Builder builder) {
        this.fieldTypes = ApiTypeHelper.unmodifiableRequired(builder.fieldTypes, (Object)this, "fieldTypes");
        this.runtimeFieldTypes = ApiTypeHelper.unmodifiable(builder.runtimeFieldTypes);
    }

    public static FieldTypesMappings of(Function<Builder, ObjectBuilder<FieldTypesMappings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<FieldTypes> fieldTypes() {
        return this.fieldTypes;
    }

    public final List<RuntimeFieldTypes> runtimeFieldTypes() {
        return this.runtimeFieldTypes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fieldTypes)) {
            generator.writeKey("field_types");
            generator.writeStartArray();
            for (FieldTypes fieldTypes : this.fieldTypes) {
                fieldTypes.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.runtimeFieldTypes)) {
            generator.writeKey("runtime_field_types");
            generator.writeStartArray();
            for (RuntimeFieldTypes runtimeFieldTypes : this.runtimeFieldTypes) {
                runtimeFieldTypes.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupFieldTypesMappingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fieldTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "field_types");
        op.add(Builder::runtimeFieldTypes, JsonpDeserializer.arrayDeserializer(RuntimeFieldTypes._DESERIALIZER), "runtime_field_types");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FieldTypesMappings> {
        private List<FieldTypes> fieldTypes;
        @Nullable
        private List<RuntimeFieldTypes> runtimeFieldTypes;

        public final Builder fieldTypes(List<FieldTypes> list) {
            this.fieldTypes = Builder._listAddAll(this.fieldTypes, list);
            return this;
        }

        public final Builder fieldTypes(FieldTypes value, FieldTypes ... values) {
            this.fieldTypes = Builder._listAdd(this.fieldTypes, value, values);
            return this;
        }

        public final Builder fieldTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.fieldTypes(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        public final Builder runtimeFieldTypes(List<RuntimeFieldTypes> list) {
            this.runtimeFieldTypes = Builder._listAddAll(this.runtimeFieldTypes, list);
            return this;
        }

        public final Builder runtimeFieldTypes(RuntimeFieldTypes value, RuntimeFieldTypes ... values) {
            this.runtimeFieldTypes = Builder._listAdd(this.runtimeFieldTypes, value, values);
            return this;
        }

        public final Builder runtimeFieldTypes(Function<RuntimeFieldTypes.Builder, ObjectBuilder<RuntimeFieldTypes>> fn) {
            return this.runtimeFieldTypes(fn.apply(new RuntimeFieldTypes.Builder()).build(), new RuntimeFieldTypes[0]);
        }

        @Override
        public FieldTypesMappings build() {
            this._checkSingleUse();
            return new FieldTypesMappings(this);
        }
    }
}

