/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.file;

import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.dboe.base.file.BinaryDataFile;

public class BinaryDataFileWriteBuffered
implements BinaryDataFile {
    private static final int SIZE = 131072;
    private final Object sync = new Object();
    private final byte[] buffer;
    private volatile int bufferLength;
    private final BinaryDataFile other;

    public BinaryDataFileWriteBuffered(BinaryDataFile other) {
        this(other, 131072);
    }

    public BinaryDataFileWriteBuffered(BinaryDataFile other, int bufferSize) {
        this.other = other;
        this.buffer = new byte[bufferSize];
        this.bufferLength = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        Object object = this.sync;
        synchronized (object) {
            this.other.open();
            this.bufferLength = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isOpen()) {
                return;
            }
            this.writeBuffer();
            this.other.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.sync;
        synchronized (object) {
            return this.other.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() {
        Object object = this.sync;
        synchronized (object) {
            return this.other.length() + (long)this.bufferLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long posn) {
        Object object = this.sync;
        synchronized (object) {
            this.checkOpen();
            long otherLen = this.other.length();
            if (this.bufferLength > 0) {
                if (posn >= otherLen) {
                    long bufLen = posn - otherLen;
                    if (bufLen < (long)this.bufferLength) {
                        this.bufferLength = (int)bufLen;
                        return;
                    }
                    this.writeBuffer();
                } else {
                    this.bufferLength = 0;
                }
            }
            this.other.truncate(posn);
        }
    }

    private void checkOpen() {
        if (!this.other.isOpen()) {
            throw new RuntimeIOException("Not open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(long posn, byte[] b, int start, int length) {
        Object object = this.sync;
        synchronized (object) {
            this.checkOpen();
            this.switchToReadMode();
            return this.other.read(posn, b, start, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(byte[] buf, int off, int len) {
        Object object = this.sync;
        synchronized (object) {
            this.checkOpen();
            this.switchToWriteMode();
            long x = this.length();
            if (this.bufferLength + len > 131072) {
                this.writeBuffer();
            }
            if (this.bufferLength + len <= 131072) {
                System.arraycopy(buf, off, this.buffer, this.bufferLength, len);
                this.bufferLength += len;
                return x;
            }
            this.other.write(buf, off, len);
            return x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        Object object = this.sync;
        synchronized (object) {
            this.writeBuffer();
            this.other.sync();
        }
    }

    private void writeBuffer() {
        if (this.bufferLength > 0) {
            this.other.write(this.buffer, 0, this.bufferLength);
            this.bufferLength = 0;
        }
    }

    protected void switchToWriteMode() {
    }

    protected void switchToReadMode() {
        this.writeBuffer();
    }
}

