/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.model.AsNamed;
import org.apache.jena.ontapi.model.HasDisjoint;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDisjoint;
import org.apache.jena.ontapi.model.OntEntity;
import org.apache.jena.ontapi.model.OntNamedProperty;
import org.apache.jena.ontapi.model.OntNegativeAssertion;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntRelationalProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;

public interface OntIndividual
extends OntObject,
AsNamed<Named>,
HasDisjoint<OntIndividual> {
    public OntIndividual detachClass(Resource var1);

    public Stream<OntClass> classes(boolean var1);

    @Override
    public Stream<OntStatement> content();

    @Override
    default public Named asNamed() {
        return (Named)this.as(Named.class);
    }

    default public Stream<OntClass> classes() {
        return this.classes(false);
    }

    default public boolean hasOntClass(OntClass clazz, boolean direct) {
        Objects.requireNonNull(clazz);
        if (!clazz.canAsAssertionClass()) {
            return false;
        }
        try (Stream<OntClass> classes = this.classes(direct);){
            boolean bl = classes.anyMatch(clazz::equals);
            return bl;
        }
    }

    default public Optional<OntClass> ontClass() {
        try (Stream<OntClass> classes = this.objects(RDF.type, OntClass.class);){
            Optional<OntClass> optional = classes.findFirst();
            return optional;
        }
    }

    default public Stream<OntIndividual> sameIndividuals() {
        return this.objects(OWL2.sameAs, OntIndividual.class);
    }

    @Override
    default public Stream<OntDisjoint.Individuals> disjoints() {
        return this.getModel().ontObjects(OntDisjoint.Individuals.class).filter(d -> d.members().anyMatch(this::equals));
    }

    default public Stream<OntIndividual> differentIndividuals() {
        return this.objects(OWL2.differentFrom, OntIndividual.class);
    }

    default public Stream<OntStatement> positiveAssertions() {
        return this.statements().filter(s -> s.getPredicate().canAs(OntNamedProperty.class));
    }

    default public Stream<OntStatement> positiveAssertions(OntNamedProperty predicate) {
        return this.statements(predicate);
    }

    default public Stream<OntNegativeAssertion> negativeAssertions() {
        return this.getModel().statements(null, OWL2.sourceIndividual, (RDFNode)this).map(x -> x.getSubject().getAs(OntNegativeAssertion.class)).filter(Objects::nonNull);
    }

    default public Stream<OntNegativeAssertion> negativeAssertions(OntRelationalProperty property) {
        Stream<OntNegativeAssertion> res = this.negativeAssertions();
        if (property == null) {
            return res;
        }
        return res.filter(x -> property.equals(x.getProperty()));
    }

    default public OntStatement addClassAssertion(OntClass clazz) {
        return this.addStatement(RDF.type, (RDFNode)clazz);
    }

    default public OntStatement addDifferentFromStatement(OntIndividual other) {
        return this.addStatement(OWL2.differentFrom, (RDFNode)other);
    }

    default public OntStatement addSameAsStatement(OntIndividual other) {
        return this.addStatement(OWL2.sameAs, (RDFNode)other);
    }

    default public OntIndividual attachClass(OntClass clazz) {
        this.addClassAssertion(clazz);
        return this;
    }

    default public OntIndividual addDifferentIndividual(OntIndividual other) {
        this.addDifferentFromStatement(other);
        return this;
    }

    default public OntIndividual addSameIndividual(OntIndividual other) {
        this.addSameAsStatement(other);
        return this;
    }

    default public OntIndividual addAssertion(OntAnnotationProperty property, RDFNode value) {
        return this.addProperty(property, value);
    }

    default public OntIndividual addAssertion(OntDataProperty property, Literal value) {
        return this.addProperty(property, (RDFNode)value);
    }

    default public OntIndividual addAssertion(OntObjectProperty.Named property, OntIndividual value) {
        return this.addProperty(property, (RDFNode)value);
    }

    default public OntIndividual addProperty(OntNamedProperty property, RDFNode value) {
        this.addStatement(property, value);
        return this;
    }

    default public OntIndividual addNegativeAssertion(OntObjectProperty property, OntIndividual value) {
        property.addNegativeAssertion(this, value);
        return this;
    }

    default public OntIndividual addNegativeAssertion(OntDataProperty property, Literal value) {
        property.addNegativeAssertion(this, value);
        return this;
    }

    default public OntIndividual removeAssertion(OntNamedProperty property, RDFNode value) {
        this.statements(property).filter(x -> x.getPredicate().canAs(OntNamedProperty.class) && (value == null || value.equals(x.getObject()))).toList().forEach(x -> x.getModel().remove(x.clearAnnotations()));
        return this;
    }

    default public OntIndividual removeNegativeAssertion(OntRelationalProperty property, RDFNode value) {
        this.negativeAssertions(property).filter(x -> value == null || value.equals(x.getTarget())).toList().forEach(x -> this.getModel().removeOntObject((OntObject)x));
        return this;
    }

    default public OntIndividual removeDifferentIndividual(Resource other) {
        this.remove(OWL2.differentFrom, (RDFNode)other);
        return this;
    }

    default public OntIndividual removeSameIndividual(Resource other) {
        this.remove(OWL2.sameAs, (RDFNode)other);
        return this;
    }

    @Override
    default public OntIndividual addComment(String txt) {
        return this.addComment(txt, null);
    }

    @Override
    default public OntIndividual addComment(String txt, String lang) {
        return this.annotate(this.getModel().getRDFSComment(), txt, lang);
    }

    @Override
    default public OntIndividual addLabel(String txt) {
        return this.addLabel(txt, null);
    }

    @Override
    default public OntIndividual addLabel(String txt, String lang) {
        return this.annotate(this.getModel().getRDFSLabel(), txt, lang);
    }

    @Override
    default public OntIndividual annotate(OntAnnotationProperty predicate, String txt, String lang) {
        return this.annotate(predicate, (RDFNode)this.getModel().createLiteral(txt, lang));
    }

    @Override
    default public OntIndividual annotate(OntAnnotationProperty predicate, RDFNode value) {
        this.addAnnotation(predicate, value);
        return this;
    }

    public static interface Named
    extends OntIndividual,
    OntEntity {
        @Override
        default public Named asNamed() {
            return this;
        }
    }

    public static interface Anonymous
    extends OntIndividual {
        @Override
        public Anonymous detachClass(Resource var1) throws OntJenaException;
    }
}

