/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.parsers.gml;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.jts.CoordinateSequenceDimensions;
import org.apache.jena.geosparql.implementation.jts.CustomCoordinateSequence;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GMLWriter {
    public static final Namespace GML_NAMESPACE = Namespace.getNamespace("gml", "http://www.opengis.net/gml/3.2");
    private static final XMLOutputter XML_OUTPUT = new XMLOutputter();

    public static String write(GeometryWrapper geometryWrapper) {
        Geometry geometry = geometryWrapper.getParsingGeometry();
        CoordinateSequenceDimensions dimensions = geometryWrapper.getCoordinateSequenceDimensions();
        String srsName = geometryWrapper.getSrsURI();
        Element gmlElement = GMLWriter.expand(geometry, dimensions, srsName);
        String output = XML_OUTPUT.outputString(gmlElement);
        return output;
    }

    private static Element expand(Geometry geometry, CoordinateSequenceDimensions dimensions, String srsName) {
        String srsDimension = GMLWriter.convertDimensions(dimensions);
        return switch (geometry.getGeometryType()) {
            case "Point" -> {
                Point point = (Point)geometry;
                yield GMLWriter.buildPoint(point.getCoordinateSequence(), srsName);
            }
            case "LineString" -> {
                LineString lineString = (LineString)geometry;
                yield GMLWriter.buildLineString(lineString.getCoordinateSequence(), srsName);
            }
            case "Polygon" -> {
                Polygon polygon = (Polygon)geometry;
                yield GMLWriter.buildPolygon(polygon, srsName);
            }
            case "MultiPoint" -> {
                MultiPoint multiPoint = (MultiPoint)geometry;
                yield GMLWriter.buildMultiPoint(multiPoint, srsName);
            }
            case "MultiLineString" -> {
                MultiLineString multiLineString = (MultiLineString)geometry;
                yield GMLWriter.buildMultiLineString(multiLineString, srsName);
            }
            case "MultiPolygon" -> {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                yield GMLWriter.buildMultiPolygon(multiPolygon, srsDimension, srsName);
            }
            case "GeometryCollection" -> {
                GeometryCollection geometryCollection = (GeometryCollection)geometry;
                yield GMLWriter.buildMultiGeometry(geometryCollection, dimensions, srsName);
            }
            default -> throw new DatatypeFormatException("Geometry type not supported: " + geometry.getGeometryType());
        };
    }

    public static String convertToGMLText(CustomCoordinateSequence coordSequence) {
        StringBuilder sb = new StringBuilder();
        int size = coordSequence.getSize();
        if (size != 0) {
            String coordText = coordSequence.getCoordinateText(0);
            sb.append(coordText);
            for (int i = 1; i < size; ++i) {
                sb.append(" ");
                coordText = coordSequence.getCoordinateText(i);
                sb.append(coordText);
            }
        } else {
            sb.append("");
        }
        return sb.toString();
    }

    private static Element buildPoint(CoordinateSequence coordSeq, String srsName) {
        CustomCoordinateSequence coordSequence = (CustomCoordinateSequence)coordSeq;
        Element gmlRoot = new Element("Point", GML_NAMESPACE);
        gmlRoot.setAttribute("srsName", srsName);
        if (coordSequence.size() > 0) {
            Element pos = new Element("pos", GML_NAMESPACE);
            pos.addContent(GMLWriter.convertToGMLText(coordSequence));
            gmlRoot.addContent(pos);
        }
        return gmlRoot;
    }

    private static Element buildLineString(CoordinateSequence coordSeq, String srsName) {
        CustomCoordinateSequence coordSequence = (CustomCoordinateSequence)coordSeq;
        Element gmlRoot = new Element("LineString", GML_NAMESPACE);
        gmlRoot.setAttribute("srsName", srsName);
        if (coordSequence.size() > 0) {
            Element posList = new Element("posList", GML_NAMESPACE);
            posList.addContent(GMLWriter.convertToGMLText(coordSequence));
            gmlRoot.addContent(posList);
        }
        return gmlRoot;
    }

    private static Element buildPolygon(Polygon polygon, String srsName) {
        Element gmlRoot = new Element(polygon.getGeometryType(), GML_NAMESPACE);
        gmlRoot.setAttribute("srsName", srsName);
        if (!polygon.isEmpty()) {
            LinearRing lineString = polygon.getExteriorRing();
            CustomCoordinateSequence coordSequence = (CustomCoordinateSequence)lineString.getCoordinateSequence();
            Element exterior = new Element("exterior", GML_NAMESPACE);
            Element exteriorLinearRing = new Element("LinearRing", GML_NAMESPACE);
            Element exteriorPosList = new Element("posList", GML_NAMESPACE);
            exteriorPosList.addContent(GMLWriter.convertToGMLText(coordSequence));
            exteriorLinearRing.addContent(exteriorPosList);
            exterior.addContent(exteriorLinearRing);
            gmlRoot.addContent(exterior);
            int interiorRings = polygon.getNumInteriorRing();
            for (int i = 0; i < interiorRings; ++i) {
                Element interior = new Element("interior", GML_NAMESPACE);
                Element interiorLinearRing = new Element("LinearRing", GML_NAMESPACE);
                Element innerPosList = new Element("posList", GML_NAMESPACE);
                LinearRing innerLineString = polygon.getInteriorRingN(i);
                CustomCoordinateSequence innerCoordSequence = (CustomCoordinateSequence)innerLineString.getCoordinateSequence();
                innerPosList.addContent(GMLWriter.convertToGMLText(innerCoordSequence));
                interiorLinearRing.addContent(innerPosList);
                interior.addContent(interiorLinearRing);
                gmlRoot.addContent(interior);
            }
        }
        return gmlRoot;
    }

    private static Element buildMultiPoint(MultiPoint multiPoint, String srsName) {
        Element gmlRoot = new Element(multiPoint.getGeometryType(), GML_NAMESPACE);
        gmlRoot.setAttribute("srsName", srsName);
        if (!multiPoint.isEmpty()) {
            int geomCount = multiPoint.getNumGeometries();
            for (int i = 0; i < geomCount; ++i) {
                Element pointMember = new Element("pointMember", GML_NAMESPACE);
                Point point = (Point)multiPoint.getGeometryN(i);
                Element pointElement = GMLWriter.buildPoint(point.getCoordinateSequence(), srsName);
                pointMember.addContent(pointElement);
                gmlRoot.addContent(pointMember);
            }
        }
        return gmlRoot;
    }

    private static Element buildMultiLineString(MultiLineString multiLineString, String srsName) {
        Element gmlRoot = new Element("MultiCurve", GML_NAMESPACE);
        gmlRoot.setAttribute("srsName", srsName);
        if (!multiLineString.isEmpty()) {
            int geomCount = multiLineString.getNumGeometries();
            for (int i = 0; i < geomCount; ++i) {
                Element lineStringMember = new Element("curveMember", GML_NAMESPACE);
                LineString lineString = (LineString)multiLineString.getGeometryN(i);
                Element lineStringElement = GMLWriter.buildLineString(lineString.getCoordinateSequence(), srsName);
                lineStringMember.addContent(lineStringElement);
                gmlRoot.addContent(lineStringMember);
            }
        }
        return gmlRoot;
    }

    private static Element buildMultiPolygon(MultiPolygon multiPolygon, String dimensionString, String srsName) {
        Element gmlRoot = new Element("MultiSurface", GML_NAMESPACE);
        gmlRoot.setAttribute("srsName", srsName);
        if (!multiPolygon.isEmpty()) {
            int geomCount = multiPolygon.getNumGeometries();
            for (int i = 0; i < geomCount; ++i) {
                Element polygonMember = new Element("surfaceMember", GML_NAMESPACE);
                Polygon polygon = (Polygon)multiPolygon.getGeometryN(i);
                polygonMember.addContent(GMLWriter.buildPolygon(polygon, srsName));
                gmlRoot.addContent(polygonMember);
            }
        }
        return gmlRoot;
    }

    private static Element buildMultiGeometry(GeometryCollection geometryCollection, CoordinateSequenceDimensions dimensions, String srsName) {
        Element gmlRoot = new Element("MultiGeometry", GML_NAMESPACE);
        gmlRoot.setAttribute("srsName", srsName);
        if (!geometryCollection.isEmpty()) {
            int geomCount = geometryCollection.getNumGeometries();
            for (int i = 0; i < geomCount; ++i) {
                Element geometryMember = new Element("geometryMember", GML_NAMESPACE);
                Geometry geometry = geometryCollection.getGeometryN(i);
                geometryMember.addContent(GMLWriter.expand(geometry, dimensions, srsName));
                gmlRoot.addContent(geometryMember);
            }
        }
        return gmlRoot;
    }

    private static String convertDimensions(CoordinateSequenceDimensions dimensions) {
        switch (dimensions) {
            case XYZ: {
                return "3";
            }
            case XYZM: {
                return "3";
            }
            case XYM: {
                return "2";
            }
        }
        return "2";
    }
}

