/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class Timeouts {
    private static final long UNSET_AMOUNT = -1L;

    public static Pair<Long, Long> parseTimeoutStr(String str2, TimeUnit unit) {
        try {
            if (str2.contains(",")) {
                String[] a = str2.split(",");
                if (a.length > 2) {
                    return null;
                }
                long x1 = Long.parseLong(a[0]);
                x1 = unit.toMillis(x1);
                long x2 = Long.parseLong(a[1]);
                x2 = unit.toMillis(x2);
                return Pair.create(x1, x2);
            }
            long x = Long.parseLong(str2);
            x = unit.toMillis(x);
            return Pair.create(-1L, x);
        }
        catch (Exception ex) {
            Log.warn(Timeouts.class, "Failed to parse timeout string: " + str2 + ": " + ex.getMessage());
            return null;
        }
    }

    public static void applyDefaultTimeout(TimeoutBuilderImpl builder, Timeout timeout) {
        if (timeout != null) {
            if (!builder.hasInitialTimeout()) {
                builder.initialTimeout(timeout.initialTimeout().amount(), timeout.initialTimeout().unit());
            }
            if (!builder.hasOverallTimeout()) {
                builder.overallTimeout(timeout.overallTimeout().amount(), timeout.overallTimeout().unit());
            }
        }
    }

    public static Timeout extractQueryTimeout(Context cxt) {
        return Timeouts.extractTimeout(cxt, ARQ.queryTimeout);
    }

    public static Timeout extractUpdateTimeout(Context cxt) {
        return Timeouts.extractTimeout(cxt, ARQ.updateTimeout);
    }

    public static Timeout extractTimeout(Context cxt, Symbol symbol) {
        Object obj = cxt.get(symbol);
        return Timeouts.parseTimeout(obj);
    }

    public static Timeout parseTimeout(Object obj) {
        Timeout result = Timeout.UNSET;
        if (obj != null) {
            try {
                if (obj instanceof Timeout) {
                    Timeout to;
                    result = to = (Timeout)obj;
                } else if (obj instanceof Number) {
                    Number n = (Number)obj;
                    long x = n.longValue();
                    result = new Timeout(-1L, x);
                } else if (obj instanceof String) {
                    String str2 = (String)obj;
                    Pair<Long, Long> pair = Timeouts.parseTimeoutStr(str2, TimeUnit.MILLISECONDS);
                    if (pair == null) {
                        Log.warn(Timeouts.class, "Bad timeout string: " + str2);
                        return result;
                    }
                    result = new Timeout(pair.getLeft(), pair.getRight());
                } else {
                    Log.warn(Timeouts.class, "Can't interpret timeout: " + String.valueOf(obj));
                }
            }
            catch (Exception ex) {
                Log.warn(Timeouts.class, "Exception setting timeouts (context) from: " + String.valueOf(obj), ex);
            }
        }
        return result;
    }

    public static void setQueryTimeout(Context cxt, Timeout timeout) {
        Timeouts.setTimeout(cxt, ARQ.queryTimeout, timeout);
    }

    public static void setUpdateTimeout(Context cxt, Timeout timeout) {
        Timeouts.setTimeout(cxt, ARQ.updateTimeout, timeout);
    }

    public static void setTimeout(Context cxt, Symbol symbol, Timeout timeout) {
        Object obj = Timeouts.toContextValue(timeout);
        cxt.set(symbol, obj);
    }

    public static Object toContextValue(Timeout timeout) {
        String result = timeout == null ? null : (timeout.hasInitialTimeout() ? Timeouts.toString(timeout) : (timeout.hasOverallTimeout() ? Long.valueOf(timeout.overallTimeoutMillis()) : null));
        return result;
    }

    public static String toString(Timeout timeout) {
        String result = timeout.hasInitialTimeout() ? timeout.initialTimeoutMillis() + "," + timeout.overallTimeoutMillis() : (timeout.hasOverallTimeout() ? Long.toString(timeout.overallTimeoutMillis()) : null);
        return result;
    }

    public static void applyDefaultQueryTimeoutFromContext(TimeoutBuilderImpl builder, Context cxt) {
        Timeout queryTimeout = Timeouts.extractQueryTimeout(cxt);
        Timeouts.applyDefaultTimeout(builder, queryTimeout);
    }

    private static TimeUnit nullToMillis(TimeUnit unit) {
        return unit != null ? unit : TimeUnit.MILLISECONDS;
    }

    public static class TimeoutBuilderImpl {
        protected long initialTimeout = -1L;
        protected TimeUnit initialTimeoutUnit = null;
        protected long overallTimeout = -1L;
        protected TimeUnit overallTimeoutUnit = null;

        public TimeoutBuilderImpl timeout(Timeout timeout) {
            this.initialTimeout(timeout.initialTimeout().amount(), timeout.initialTimeout().unit());
            this.overallTimeout(timeout.overallTimeout().amount(), timeout.overallTimeout().unit());
            return this;
        }

        public TimeoutBuilderImpl timeout(long value, TimeUnit timeUnit) {
            this.initialTimeout(-1L, null);
            this.overallTimeout(value, timeUnit);
            return this;
        }

        public TimeoutBuilderImpl initialTimeout(long value, TimeUnit timeUnit) {
            this.initialTimeout = value < 0L ? -1L : value;
            this.initialTimeoutUnit = timeUnit;
            return this;
        }

        public boolean hasInitialTimeout() {
            return this.initialTimeout >= 0L;
        }

        public TimeoutBuilderImpl overallTimeout(long value, TimeUnit timeUnit) {
            this.overallTimeout = value;
            this.overallTimeoutUnit = timeUnit;
            return this;
        }

        public boolean hasOverallTimeout() {
            return this.overallTimeout >= 0L;
        }

        public Timeout build() {
            return new Timeout(this.initialTimeout, Timeouts.nullToMillis(this.initialTimeoutUnit), this.overallTimeout, Timeouts.nullToMillis(this.overallTimeoutUnit));
        }
    }

    public record Timeout(DurationWithUnit initialTimeout, DurationWithUnit overallTimeout) {
        public static Timeout UNSET = new Timeout(-1L, -1L);

        public Timeout(long initialTimeout, TimeUnit initialTimeoutUnit, long overallTimeout, TimeUnit overallTimeoutUnit) {
            this(DurationWithUnit.of(initialTimeout, initialTimeoutUnit), DurationWithUnit.of(overallTimeout, overallTimeoutUnit));
        }

        public Timeout(long initialTimeout, long overallTimeout) {
            this(initialTimeout, TimeUnit.MILLISECONDS, overallTimeout, TimeUnit.MILLISECONDS);
        }

        public boolean hasInitialTimeout() {
            return this.initialTimeout().isSet();
        }

        public long initialTimeoutMillis() {
            return this.initialTimeout().asMillis();
        }

        public boolean hasOverallTimeout() {
            return this.overallTimeout().isSet();
        }

        public long overallTimeoutMillis() {
            return this.overallTimeout().asMillis();
        }

        public boolean hasTimeout() {
            return this.hasInitialTimeout() || this.hasOverallTimeout();
        }
    }

    public record DurationWithUnit(long amount, TimeUnit unit) {
        public static DurationWithUnit UNSET = new DurationWithUnit(-1L, TimeUnit.MILLISECONDS);

        public boolean isSet() {
            return this.amount >= 0L;
        }

        public long asMillis() {
            return this.amount < 0L ? this.amount : this.unit.toMillis(this.amount);
        }

        public static DurationWithUnit of(long amount, TimeUnit unit) {
            return new DurationWithUnit(amount < 0L ? -1L : amount, Timeouts.nullToMillis(unit));
        }
    }
}

