/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.modify.UpdateSink;
import org.apache.jena.sparql.modify.UsingList;
import org.apache.jena.sparql.modify.request.QuadDataAccSink;
import org.apache.jena.sparql.modify.request.UpdateWithUsing;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateException;

public class UsingUpdateSink
implements UpdateSink {
    private final UpdateSink sink;
    private final UsingList usingList;

    public UsingUpdateSink(UpdateSink sink, UsingList usingList) {
        this.sink = sink;
        this.usingList = usingList;
    }

    @Override
    public void send(Update update2) {
        if (null != this.usingList && this.usingList.usingIsPresent() && update2 instanceof UpdateWithUsing) {
            UpdateWithUsing upu = (UpdateWithUsing)update2;
            if (upu.getUsing().size() != 0 || upu.getUsingNamed().size() != 0 || upu.getWithIRI() != null) {
                throw new UpdateException("SPARQL Update: Protocol using-graph-uri or using-named-graph-uri present where update request has USING, USING NAMED or WITH");
            }
            for (Node node : this.usingList.getUsing()) {
                upu.addUsing(node);
            }
            for (Node node : this.usingList.getUsingNamed()) {
                upu.addUsingNamed(node);
            }
        }
        this.sink.send(update2);
    }

    @Override
    public QuadDataAccSink createInsertDataSink() {
        return this.sink.createInsertDataSink();
    }

    @Override
    public QuadDataAccSink createDeleteDataSink() {
        return this.sink.createDeleteDataSink();
    }

    @Override
    public void flush() {
        this.sink.flush();
    }

    @Override
    public void close() {
        this.sink.close();
    }
}

