/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.aop;

import java.lang.annotation.Annotation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;
import org.apache.shiro.subject.Subject;

public class PermissionAnnotationHandler
extends AuthorizingAnnotationHandler {
    public PermissionAnnotationHandler() {
        super(RequiresPermissions.class);
    }

    protected String[] getAnnotationValue(Annotation a) {
        RequiresPermissions rpAnnotation = (RequiresPermissions)a;
        return rpAnnotation.value();
    }

    @Override
    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (!(a instanceof RequiresPermissions)) {
            return;
        }
        RequiresPermissions rpAnnotation = (RequiresPermissions)a;
        String[] perms = this.getAnnotationValue(a);
        Subject subject = this.getSubject();
        if (perms.length == 1) {
            subject.checkPermission(perms[0]);
            return;
        }
        if (Logical.AND.equals((Object)rpAnnotation.logical())) {
            this.getSubject().checkPermissions(perms);
            return;
        }
        if (Logical.OR.equals((Object)rpAnnotation.logical())) {
            boolean hasAtLeastOnePermission = false;
            for (String permission : perms) {
                if (!this.getSubject().isPermitted(permission)) continue;
                hasAtLeastOnePermission = true;
                break;
            }
            if (!hasAtLeastOnePermission) {
                this.getSubject().checkPermission(perms[0]);
            }
        }
    }
}

