/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.authc;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.servlet.AdviceFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutFilter
extends AdviceFilter {
    public static final String DEFAULT_REDIRECT_URL = "/";
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutFilter.class);
    private String redirectUrl = "/";
    private boolean postOnlyLogout;

    @Override
    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        Subject subject = this.getSubject(request, response);
        if (this.isPostOnlyLogout() && !WebUtils.toHttp(request).getMethod().toUpperCase(Locale.ENGLISH).equals("POST")) {
            return this.onLogoutRequestNotAPost(request, response);
        }
        String redirectUrl = this.getRedirectUrl(request, response, subject);
        try {
            subject.logout();
        }
        catch (SessionException ise) {
            LOGGER.debug("Encountered session exception during logout.  This can generally safely be ignored.", ise);
        }
        this.issueRedirect(request, response, redirectUrl);
        return false;
    }

    protected Subject getSubject(ServletRequest request, ServletResponse response) {
        return SecurityUtils.getSubject();
    }

    protected void issueRedirect(ServletRequest request, ServletResponse response, String redirectUrl) throws Exception {
        WebUtils.issueRedirect(request, response, redirectUrl);
    }

    protected String getRedirectUrl(ServletRequest request, ServletResponse response, Subject subject) {
        return this.getRedirectUrl();
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    protected boolean onLogoutRequestNotAPost(ServletRequest request, ServletResponse response) {
        HttpServletResponse httpServletResponse = WebUtils.toHttp(response);
        httpServletResponse.setStatus(405);
        httpServletResponse.setHeader("Allow", "POST");
        return false;
    }

    public boolean isPostOnlyLogout() {
        return this.postOnlyLogout;
    }

    public void setPostOnlyLogout(boolean postOnlyLogout) {
        this.postOnlyLogout = postOnlyLogout;
    }
}

