/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.util.Map;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.visualizers.backend.Backend;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreCompiler
implements HashTreeTraverser {
    private static final Logger log = LoggerFactory.getLogger(PreCompiler.class);
    private final ValueReplacer replacer = new ValueReplacer();
    private final boolean isClientSide;
    private JMeterVariables clientSideVariables;

    public PreCompiler() {
        this.isClientSide = false;
    }

    public PreCompiler(boolean remote) {
        this.isClientSide = remote;
    }

    public void addNode(Object node, HashTree subTree) {
        if (this.isClientSide) {
            if (node instanceof ResultCollector || node instanceof Backend) {
                try {
                    this.replacer.replaceValues((TestElement)node);
                }
                catch (InvalidVariableException e) {
                    log.error("invalid variables in node {}", (Object)((TestElement)node).getName(), (Object)e);
                }
            }
            if (node instanceof TestPlan) {
                this.clientSideVariables = this.createVars((TestPlan)node);
            }
            if (node instanceof Arguments) {
                Map<String, String> args = this.createArgumentsMap((Arguments)node);
                this.clientSideVariables.putAll(args);
            }
        } else {
            if (node instanceof TestElement) {
                try {
                    this.replacer.replaceValues((TestElement)node);
                }
                catch (InvalidVariableException e) {
                    log.error("invalid variables in node {}", (Object)((TestElement)node).getName(), (Object)e);
                }
            }
            if (node instanceof TestPlan) {
                JMeterVariables vars = this.createVars((TestPlan)node);
                JMeterContextService.getContext().setVariables(vars);
            }
            if (node instanceof Arguments) {
                Map<String, String> args = this.createArgumentsMap((Arguments)node);
                JMeterContextService.getContext().getVariables().putAll(args);
            }
        }
    }

    private Map<String, String> createArgumentsMap(Arguments arguments) {
        arguments.setRunningVersion(true);
        Map<String, String> args = arguments.getArgumentsAsMap();
        this.replacer.addVariables(args);
        return args;
    }

    private JMeterVariables createVars(TestPlan testPlan) {
        testPlan.prepareForPreCompile();
        Map<String, String> args = testPlan.getUserDefinedVariables();
        this.replacer.setUserDefinedVariables(args);
        JMeterVariables vars = new JMeterVariables();
        vars.putAll(args);
        return vars;
    }

    public void subtractNode() {
    }

    public void processPath() {
    }

    public JMeterVariables getClientSideVariables() {
        return this.clientSideVariables;
    }
}

