/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.List;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.timers.Timer;

public class SamplePackage {
    private final List<SampleListener> sampleListeners;
    private final List<Timer> timers;
    private final List<Assertion> assertions;
    private final List<PostProcessor> postProcessors;
    private final List<PreProcessor> preProcessors;
    private final List<ConfigTestElement> configs;
    private final List<Controller> controllers;
    private Sampler sampler;

    public SamplePackage(List<ConfigTestElement> configs, List<SampleListener> listeners, List<Timer> timers, List<Assertion> assertions, List<PostProcessor> postProcessors, List<PreProcessor> preProcessors, List<Controller> controllers) {
        this.configs = configs;
        this.sampleListeners = listeners;
        this.timers = timers;
        this.assertions = assertions;
        this.postProcessors = postProcessors;
        this.preProcessors = preProcessors;
        this.controllers = controllers;
    }

    public void setRunningVersion(boolean running) {
        SamplePackage.setRunningVersion(this.configs, running);
        SamplePackage.setRunningVersion(this.sampleListeners, running);
        SamplePackage.setRunningVersion(this.assertions, running);
        SamplePackage.setRunningVersion(this.timers, running);
        SamplePackage.setRunningVersion(this.postProcessors, running);
        SamplePackage.setRunningVersion(this.preProcessors, running);
        SamplePackage.setRunningVersion(this.controllers, running);
        this.sampler.setRunningVersion(running);
    }

    private static void setRunningVersion(List<?> list, boolean running) {
        List<?> telist = list;
        for (TestElement te : telist) {
            te.setRunningVersion(running);
        }
    }

    private static void recoverRunningVersion(List<?> list) {
        List<?> telist = list;
        for (TestElement te : telist) {
            te.recoverRunningVersion();
        }
    }

    public void recoverRunningVersion() {
        SamplePackage.recoverRunningVersion(this.configs);
        SamplePackage.recoverRunningVersion(this.sampleListeners);
        SamplePackage.recoverRunningVersion(this.assertions);
        SamplePackage.recoverRunningVersion(this.timers);
        SamplePackage.recoverRunningVersion(this.postProcessors);
        SamplePackage.recoverRunningVersion(this.preProcessors);
        SamplePackage.recoverRunningVersion(this.controllers);
        this.sampler.recoverRunningVersion();
    }

    public List<SampleListener> getSampleListeners() {
        return this.sampleListeners;
    }

    public void addSampleListener(SampleListener listener) {
        this.sampleListeners.add(listener);
    }

    public List<Timer> getTimers() {
        return this.timers;
    }

    public void addPostProcessor(PostProcessor ex) {
        this.postProcessors.add(ex);
    }

    public void addPreProcessor(PreProcessor pre) {
        this.preProcessors.add(pre);
    }

    public void addTimer(Timer timer) {
        this.timers.add(timer);
    }

    public void addAssertion(Assertion asser) {
        this.assertions.add(asser);
    }

    public List<Assertion> getAssertions() {
        return this.assertions;
    }

    public List<PostProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public Sampler getSampler() {
        return this.sampler;
    }

    public void setSampler(Sampler s) {
        this.sampler = s;
    }

    public List<PreProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public List<ConfigTestElement> getConfigs() {
        return this.configs;
    }
}

