/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import org.apache.johnzon.core.Snippet;
import org.apache.johnzon.mapper.SnippetFactory;

public final class JohnzonCores {
    private static final Method CREATE_READER;

    private JohnzonCores() {
    }

    public static SnippetFactory snippetFactory(int max, JsonGeneratorFactory factory) {
        if (CREATE_READER == null) {
            return JsonValue::toString;
        }
        return Snippets.of(max, factory);
    }

    public static JsonReader map(JsonParser parser, JsonReaderFactory readerFactory) {
        if (CREATE_READER == null) {
            throw new IllegalStateException("Ensure to use johnzon-core as JSON-P provider for johnzon-mapper");
        }
        try {
            return (JsonReader)JsonReader.class.cast(CREATE_READER.invoke((Object)readerFactory, parser));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
    }

    static {
        Method m = null;
        try {
            Class<?> jrfi = Optional.ofNullable(JohnzonCores.class.getClassLoader()).orElseGet(ClassLoader::getSystemClassLoader).loadClass("org.apache.johnzon.core.JsonReaderFactoryImpl");
            m = jrfi.getDeclaredMethod("createReader", JsonParser.class);
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CREATE_READER = m;
    }

    private static class Snippets {
        private Snippets() {
        }

        private static SnippetFactory of(int max, JsonGeneratorFactory factory) {
            return arg_0 -> ((Snippet)new Snippet(max, factory)).of(arg_0);
        }
    }
}

