/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.api.filters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.filters.PageFilter;

class FilterSupportOperations {
    private static final Logger LOG = LogManager.getLogger(FilterSupportOperations.class);

    FilterSupportOperations() {
    }

    static Method methodOfNonPublicAPI(PageFilter pf, String method, String ... params) {
        if (!pf.getClass().getName().startsWith("org.apache.wiki")) {
            try {
                Class[] classes = new Class[params.length];
                for (int i = 0; i < params.length; ++i) {
                    classes[i] = Class.forName(params[i]);
                }
                return pf.getClass().getMethod(method, classes);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    static <R> R executePageFilterPhase(Supplier<R> s, Method m, PageFilter pf, Object ... params) {
        if (m != null) {
            try {
                return (R)m.invoke((Object)pf, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.warn("Problems using filter adapter: " + e.getMessage(), (Throwable)e);
            }
        }
        return s.get();
    }
}

