/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.pages.PageLock;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.preferences.Preferences;

public class ListLocksPlugin
implements Plugin {
    public String execute(Context context, Map<String, String> params) throws PluginException {
        StringBuilder result = new StringBuilder();
        PageManager mgr = (PageManager)context.getEngine().getManager(PageManager.class);
        List<PageLock> locks = mgr.getActiveLocks();
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        result.append("<table class=\"wikitable\">\n");
        result.append("<tr>\n");
        result.append("<th>").append(rb.getString("plugin.listlocks.page")).append("</th><th>").append(rb.getString("plugin.listlocks.locked.by")).append("</th><th>").append(rb.getString("plugin.listlocks.acquired")).append("</th><th>").append(rb.getString("plugin.listlocks.expires")).append("</th>\n");
        result.append("</tr>");
        if (locks.isEmpty()) {
            result.append("<tr><td colspan=\"4\" class=\"odd\">").append(rb.getString("plugin.listlocks.no.locks.exist")).append("</td></tr>\n");
        } else {
            int rowNum = 1;
            for (PageLock lock : locks) {
                result.append(rowNum % 2 != 0 ? "<tr class=\"odd\">" : "<tr>");
                result.append("<td>").append(lock.getPage()).append("</td>");
                result.append("<td>").append(lock.getLocker()).append("</td>");
                result.append("<td>").append(Preferences.renderDate(context, lock.getAcquisitionTime(), Preferences.TimeFormat.DATETIME)).append("</td>");
                result.append("<td>").append(Preferences.renderDate(context, lock.getExpiryTime(), Preferences.TimeFormat.DATETIME)).append("</td>");
                result.append("</tr>\n");
                ++rowNum;
            }
        }
        result.append("</table>");
        return result.toString();
    }
}

