/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import java.util.Map;
import java.util.logging.Level;
import org.apache.juneau.ConfigApply;
import org.apache.juneau.ConfigException;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.HtmlDocBuilder;
import org.apache.juneau.rest.MessageBundleLocation;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestCallLogger;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.StaticFileMapping;
import org.apache.juneau.rest.annotation.AnnotationUtils;
import org.apache.juneau.rest.annotation.HtmlDoc;
import org.apache.juneau.rest.annotation.Logging;
import org.apache.juneau.rest.annotation.LoggingRule;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.ClasspathResourceFinder;

@Deprecated
public class RestResourceConfigApply
extends ConfigApply<RestResource> {
    public RestResourceConfigApply(Class<RestResource> c, VarResolverSession r) {
        super(c, r);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(AnnotationInfo<RestResource> ai, PropertyStoreBuilder psb) {
        void var9_29;
        Object h;
        RestResource a = ai.getAnnotation();
        String s = null;
        ClassInfo c = ai.getClassOn();
        for (Property property : a.properties()) {
            psb.set(property.name(), this.string(property.value()));
            psb.addTo("RestContext.properties.sms", this.string(property.name()), this.string(property.value()));
        }
        for (String string : a.flags()) {
            psb.set(string, true);
            psb.addTo("RestContext.properties.sms", this.string(string), true);
        }
        if (a.serializers().length > 0) {
            psb.set("RestContext.serializers.lo", RestUtils.merge(ObjectUtils.toType(psb.peek("RestContext.serializers.lo"), Object[].class), a.serializers()));
        }
        if (a.parsers().length > 0) {
            psb.set("RestContext.parsers.lo", RestUtils.merge(ObjectUtils.toType(psb.peek("RestContext.parsers.lo"), Object[].class), a.parsers()));
        }
        if (a.partSerializer() != HttpPartSerializer.Null.class) {
            psb.set("RestContext.partSerializer.o", a.partSerializer());
        }
        if (a.partParser() != HttpPartParser.Null.class) {
            psb.set("RestContext.partParser.o", a.partParser());
        }
        psb.addTo("RestContext.encoders.lo", a.encoders());
        if (a.produces().length > 0) {
            psb.set("RestContext.produces.ls", this.strings(a.produces()));
        }
        if (a.consumes().length > 0) {
            psb.set("RestContext.consumes.ls", this.strings(a.consumes()));
        }
        for (String string : this.strings(a.attrs())) {
            String[] ra2 = RestUtils.parseKeyValuePair(string);
            if (ra2 == null) {
                throw new FormattedRuntimeException("Invalid default request attribute specified: ''{0}''.  Must be in the format: ''Name: value''", string);
            }
            if (!StringUtils.isNotEmpty(ra2[1])) continue;
            psb.addTo("RestContext.reqAttrs.smo", ra2[0], ra2[1]);
        }
        for (String string : this.strings(a.defaultRequestHeaders())) {
            h = RestUtils.parseHeader(string);
            if (h == null) {
                throw new FormattedRuntimeException("Invalid default request header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", string);
            }
            if (!StringUtils.isNotEmpty(h[1])) continue;
            psb.addTo("RestContext.reqHeaders.smo", h[0], h[1]);
        }
        if (a.defaultAccept().length() > 0 && StringUtils.isNotEmpty(s = this.string(a.defaultAccept()))) {
            psb.addTo("RestContext.reqHeaders.smo", "Accept", s);
        }
        if (a.defaultContentType().length() > 0 && StringUtils.isNotEmpty(s = this.string(a.defaultContentType()))) {
            psb.addTo("RestContext.reqHeaders.smo", "Content-Type", s);
        }
        for (String string : this.strings(a.defaultResponseHeaders())) {
            h = RestUtils.parseHeader(string);
            if (h == null) {
                throw new FormattedRuntimeException("Invalid default response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", string);
            }
            if (!StringUtils.isNotEmpty(h[1])) continue;
            psb.addTo("RestContext.resHeaders.omo", h[0], h[1]);
        }
        psb.addTo("RestContext.responseHandlers.lo", a.responseHandlers());
        psb.addTo("RestContext.converters.lo", a.converters());
        psb.addTo("RestContext.guards.lo", ArrayUtils.reverse(a.guards()));
        psb.addTo("RestContext.children.lo", a.children());
        psb.set("BeanContext.beanFilters.lc", RestUtils.merge(ObjectUtils.toType(psb.peek("BeanContext.beanFilters.lc"), Object[].class), a.beanFilters()));
        psb.set("BeanContext.pojoSwaps.lo", RestUtils.merge(ObjectUtils.toType(psb.peek("BeanContext.pojoSwaps.lo"), Object[].class), a.pojoSwaps()));
        psb.addTo("RestContext.paramResolvers.lo", a.paramResolvers());
        if (a.serializerListener() != SerializerListener.Null.class) {
            psb.set("Serializer.listener.c", a.serializerListener());
        }
        if (a.parserListener() != ParserListener.Null.class) {
            psb.set("Parser.listener.c", a.parserListener());
        }
        if (StringUtils.isNotEmpty(s = this.string(a.uriContext()))) {
            psb.set("RestContext.uriContext.s", s);
        }
        if (StringUtils.isNotEmpty(s = this.string(a.uriAuthority()))) {
            psb.set("RestContext.uriAuthority.s", s);
        }
        if (StringUtils.isNotEmpty(s = this.string(a.uriRelativity()))) {
            psb.set("RestContext.uriRelativity.s", s);
        }
        if (StringUtils.isNotEmpty(s = this.string(a.uriResolution()))) {
            psb.set("RestContext.uriResolution.s", s);
        }
        for (String string : a.staticFiles()) {
            try {
                for (StaticFileMapping sfm : CollectionUtils.reverseIterable(StaticFileMapping.parse(c.inner(), this.string(string)))) {
                    psb.addTo("RestContext.staticFiles.lo", sfm);
                }
            }
            catch (ParseException e) {
                throw new ConfigException(e, "Invalid @Resource(staticFiles) value on class ''{0}''", c);
            }
        }
        if (!a.messages().isEmpty()) {
            psb.addTo("RestContext.messages.lo", new MessageBundleLocation(c.inner(), this.string(a.messages())));
        }
        for (String string : this.strings(a.staticFileResponseHeaders())) {
            h = RestUtils.parseHeader(string);
            if (h == null) {
                throw new FormattedRuntimeException("Invalid static file response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", string);
            }
            if (!StringUtils.isNotEmpty((String)h[1])) continue;
            psb.addTo("RestContext.staticFileResponseHeaders.omo", (String)h[0], h[1]);
        }
        if (!a.useClasspathResourceCaching().isEmpty()) {
            psb.set("RestContext.useClasspathResourceCaching.b", this.bool(a.useClasspathResourceCaching()));
        }
        if (a.classpathResourceFinder() != ClasspathResourceFinder.Null.class) {
            psb.set("RestContext.classpathResourceFinder.o", a.classpathResourceFinder());
        }
        if (!a.path().isEmpty()) {
            psb.set("RestContext.path.s", this.trimLeadingSlash(this.string(a.path())));
        }
        if (!a.clientVersionHeader().isEmpty()) {
            psb.set("RestContext.clientVersionHeader.s", this.string(a.clientVersionHeader()));
        }
        if (a.resourceResolver() != RestResourceResolver.Null.class) {
            psb.set("RestContext.resourceResolver.o", a.resourceResolver());
        }
        if (a.logger() != RestLogger.Null.class) {
            psb.set("RestContext.logger.o", a.logger());
        }
        if (a.callLogger() != RestCallLogger.Null.class) {
            psb.set("RestContext.callLogger.o", a.callLogger());
        }
        if (!AnnotationUtils.empty(a.logging())) {
            Logging al = a.logging();
            ObjectMap m = new ObjectMap((Map<?, ?>)psb.peek(ObjectMap.class, "RestContext.callLoggerConfig.o"));
            if (!al.useStackTraceHashing().isEmpty()) {
                m.append("useStackTraceHashing", this.bool(al.useStackTraceHashing()));
            }
            if (!al.stackTraceHashingTimeout().isEmpty()) {
                m.append("stackTraceHashingTimeout", this.integer(al.stackTraceHashingTimeout(), "@Logging(stackTraceHashingTimeout)"));
            }
            if (!al.disabled().isEmpty()) {
                m.append("disabled", (Object)this.enablement(al.disabled()));
            }
            if (!al.level().isEmpty()) {
                m.append("level", this.level(al.level(), "@Logging(level)"));
            }
            if (al.rules().length > 0) {
                ObjectList ol = new ObjectList();
                for (LoggingRule a2 : al.rules()) {
                    ObjectMap m2 = new ObjectMap();
                    if (!a2.codes().isEmpty()) {
                        m2.append("codes", this.string(a2.codes()));
                    }
                    if (!a2.exceptions().isEmpty()) {
                        m2.append("exceptions", this.string(a2.exceptions()));
                    }
                    if (!a2.debugOnly().isEmpty()) {
                        m2.append("debugOnly", this.bool(a2.debugOnly()));
                    }
                    if (!a2.level().isEmpty()) {
                        m2.append("level", this.level(a2.level(), "@LoggingRule(level)"));
                    }
                    if (!a2.req().isEmpty()) {
                        m2.append("req", this.string(a2.req()));
                    }
                    if (!a2.res().isEmpty()) {
                        m2.append("res", this.string(a2.res()));
                    }
                    if (!a2.verbose().isEmpty()) {
                        m2.append("verbose", this.bool(a2.verbose()));
                    }
                    if (!a2.disabled().isEmpty()) {
                        m2.append("disabled", this.bool(a2.disabled()));
                    }
                    ol.add(m2);
                }
                m.put("rules", ol.appendAll(m.getObjectList("rules")));
            }
            psb.set("RestContext.callLoggerConfig.o", m);
        }
        if (a.callHandler() != RestCallHandler.Null.class) {
            psb.set("RestContext.callHandler.o", a.callHandler());
        }
        if (a.infoProvider() != RestInfoProvider.Null.class) {
            psb.set("RestContext.infoProvider.o", a.infoProvider());
        }
        if (!a.allowBodyParam().isEmpty()) {
            psb.set("RestContext.allowBodyParam.b", this.bool(a.allowBodyParam()));
        }
        if (!a.allowedHeaderParams().isEmpty()) {
            psb.set("RestContext.allowedHeaderParams.s", this.string(a.allowedHeaderParams()));
        }
        if (!a.allowedMethodHeaders().isEmpty()) {
            psb.set("RestContext.allowedMethodHeaders.s", this.string(a.allowedMethodHeaders()));
        }
        if (!a.allowedMethodParams().isEmpty()) {
            psb.set("RestContext.allowedMethodParams.s", this.string(a.allowedMethodParams()));
        }
        if (!a.allowHeaderParams().isEmpty()) {
            psb.set("RestContext.allowHeaderParams.b", this.bool(a.allowHeaderParams()));
        }
        if (!a.renderResponseStackTraces().isEmpty()) {
            psb.set("RestContext.renderResponseStackTraces.b", this.bool(a.renderResponseStackTraces()));
        }
        if (!a.useStackTraceHashes().isEmpty()) {
            psb.set("RestContext.useStackTraceHashes.b", this.bool(a.useStackTraceHashes()));
        }
        if (!a.defaultCharset().isEmpty()) {
            psb.set("RestContext.defaultCharset.s", this.string(a.defaultCharset()));
        }
        if (!a.maxInput().isEmpty()) {
            psb.set("RestContext.maxInput.s", this.string(a.maxInput()));
        }
        if (!a.debug().isEmpty()) {
            psb.set("RestContext.debug.s", a.debug());
        }
        psb.addTo("RestContext.mimeTypes.ss", this.strings(a.mimeTypes()));
        if (!a.rolesDeclared().isEmpty()) {
            psb.addTo("RestContext.rolesDeclared.ss", this.strings(a.rolesDeclared()));
        }
        if (!a.roleGuard().isEmpty()) {
            psb.addTo("RestContext.roleGuard.ss", this.string(a.roleGuard()));
        }
        HtmlDoc hd = a.htmldoc();
        new HtmlDocBuilder(psb).process(hd);
        Class<? extends Widget>[] classArray = hd.widgets();
        int n = classArray.length;
        boolean bl = false;
        while (var9_29 < n) {
            Class<? extends Widget> wc = classArray[var9_29];
            Widget w = ClassUtils.castOrCreate(Widget.class, wc);
            psb.addTo("RestContext.widgets.lo", w);
            psb.addTo("HtmlDocSerializer.script.ls", "$W{" + w.getName() + ".script}");
            psb.addTo("HtmlDocSerializer.script.ls", "$W{" + w.getName() + ".style}");
            ++var9_29;
        }
    }

    private String trimLeadingSlash(String value) {
        if (StringUtils.startsWith(value, '/')) {
            return value.substring(1);
        }
        return value;
    }

    private Enablement enablement(String in) {
        return Enablement.fromString(this.string(in));
    }

    private Level level(String in, String loc) {
        try {
            return Level.parse(this.string(in).toUpperCase());
        }
        catch (Exception e) {
            throw new ConfigException("Invalid syntax for level on annotation @RestResource({0}): {1}", loc, in);
        }
    }
}

