/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.Set;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.marshall.SimpleJson;

@Bean(bpi="v1,v2")
public class BeanDiff {
    private OMap v1 = new OMap();
    private OMap v2 = new OMap();

    public <T> BeanDiff(BeanContext bc, T first, T second, Set<String> include, Set<String> exclude) {
        if (first == null && second == null) {
            return;
        }
        BeanSession bs = bc.createBeanSession();
        BeanMap<T> bm1 = first == null ? null : bs.toBeanMap(first);
        BeanMap<T> bm2 = second == null ? null : bs.toBeanMap(second);
        Set<String> keys = bm1 != null ? bm1.keySet() : bm2.keySet();
        for (String k : keys) {
            Object o2;
            Object o1;
            if (include != null && !include.contains(k) || exclude != null && exclude.contains(k) || !ObjectUtils.ne(o1 = bm1 == null ? null : bm1.get(k), o2 = bm2 == null ? null : bm2.get(k))) continue;
            if (o1 != null) {
                this.v1.put(k, o1);
            }
            if (o2 == null) continue;
            this.v2.put(k, o2);
        }
    }

    public static <T> Builder<T> create(T first, T second) {
        return new Builder<T>().first(first).second(second);
    }

    public boolean hasDiffs() {
        return this.v1.size() > 0 || this.v2.size() > 0;
    }

    public OMap getV1() {
        return this.v1;
    }

    public OMap getV2() {
        return this.v2;
    }

    public String toString() {
        return SimpleJson.DEFAULT.toString(this);
    }

    public static class Builder<T> {
        T first;
        T second;
        BeanContext beanContext = BeanContext.DEFAULT;
        Set<String> include;
        Set<String> exclude;

        public Builder<T> first(T value) {
            this.first = value;
            return this;
        }

        public Builder<T> second(T value) {
            this.second = value;
            return this;
        }

        public Builder<T> beanContext(BeanContext value) {
            this.beanContext = value;
            return this;
        }

        public Builder<T> include(String ... properties) {
            this.include = ASet.of(properties);
            return this;
        }

        public Builder<T> include(Set<String> properties) {
            this.include = properties;
            return this;
        }

        public Builder<T> exclude(String ... properties) {
            this.exclude = ASet.of(properties);
            return this;
        }

        public Builder<T> exclude(Set<String> properties) {
            this.exclude = properties;
            return this;
        }

        public BeanDiff build() {
            return new BeanDiff(this.beanContext, this.first, this.second, this.include, this.exclude);
        }
    }
}

