/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public interface MetaProvider {
    public static final MetaProvider DEFAULT = new MetaProvider(){

        @Override
        public <A extends Annotation> List<A> getAnnotations(Class<A> a, Class<?> c) {
            if (a == null || c == null) {
                return Collections.emptyList();
            }
            A aa = c.getAnnotation(a);
            return aa == null ? Collections.emptyList() : Collections.singletonList(aa);
        }

        @Override
        public <A extends Annotation> List<A> getDeclaredAnnotations(Class<A> a, Class<?> c) {
            if (a == null || c == null) {
                return Collections.emptyList();
            }
            A aa = c.getDeclaredAnnotation(a);
            return aa == null ? Collections.emptyList() : Collections.singletonList(aa);
        }

        @Override
        public <A extends Annotation> List<A> getAnnotations(Class<A> a, Method m) {
            if (a == null || m == null) {
                return Collections.emptyList();
            }
            A aa = m.getAnnotation(a);
            return aa == null ? Collections.emptyList() : Collections.singletonList(aa);
        }

        @Override
        public <A extends Annotation> List<A> getAnnotations(Class<A> a, Field f) {
            if (a == null || f == null) {
                return Collections.emptyList();
            }
            A aa = f.getAnnotation(a);
            return aa == null ? Collections.emptyList() : Collections.singletonList(aa);
        }

        @Override
        public <A extends Annotation> List<A> getAnnotations(Class<A> a, Constructor<?> c) {
            if (a == null || c == null) {
                return Collections.emptyList();
            }
            Object aa = c.getAnnotation(a);
            return aa == null ? Collections.emptyList() : Collections.singletonList(aa);
        }
    };

    public <A extends Annotation> List<A> getAnnotations(Class<A> var1, Class<?> var2);

    public <A extends Annotation> List<A> getDeclaredAnnotations(Class<A> var1, Class<?> var2);

    public <A extends Annotation> List<A> getAnnotations(Class<A> var1, Method var2);

    public <A extends Annotation> List<A> getAnnotations(Class<A> var1, Field var2);

    public <A extends Annotation> List<A> getAnnotations(Class<A> var1, Constructor<?> var2);
}

