/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Enablement;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.annotation.TargetedAnnotationTBuilder;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.rest.RestChildren;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.RestOperations;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.Swagger;
import org.apache.juneau.rest.annotation.SwaggerAnnotation;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.converter.RestConverter;
import org.apache.juneau.rest.debug.DebugEnablement;
import org.apache.juneau.rest.guard.RestGuard;
import org.apache.juneau.rest.httppart.BasicNamedAttribute;
import org.apache.juneau.rest.httppart.NamedAttribute;
import org.apache.juneau.rest.logging.RestLogger;
import org.apache.juneau.rest.processor.ResponseProcessor;
import org.apache.juneau.rest.staticfile.StaticFiles;
import org.apache.juneau.rest.swagger.SwaggerProvider;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.svl.VarResolverSession;

public class RestAnnotation {
    public static final Rest DEFAULT = RestAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return RestAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return RestAnnotation.create().on(on);
    }

    public static class RestOpContextApply
    extends AnnotationApplier<Rest, RestOpContext.Builder> {
        public RestOpContextApply(VarResolverSession vr) {
            super(Rest.class, RestOpContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Rest> ai, RestOpContext.Builder b) {
            Rest a = ai.inner();
            this.stream(a.produces()).map(MediaType::of).forEach(x -> b.produces((MediaType)x));
            this.stream(a.consumes()).map(MediaType::of).forEach(x -> b.consumes((MediaType)x));
            b.converters().append(a.converters());
            b.guards().append(a.guards());
            this.string(a.defaultCharset()).map(Charset::forName).ifPresent(x -> b.defaultCharset((Charset)x));
            this.string(a.maxInput()).ifPresent(x -> b.maxInput((String)x));
            this.cdl(a.rolesDeclared()).forEach(x -> b.rolesDeclared((String)x));
            this.string(a.roleGuard()).ifPresent(x -> b.roleGuard((String)x));
        }
    }

    public static class RestContextApply
    extends AnnotationApplier<Rest, RestContext.Builder> {
        public RestContextApply(VarResolverSession vr) {
            super(Rest.class, RestContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Rest> ai, RestContext.Builder b) {
            Rest a = ai.inner();
            this.classes(a.serializers()).ifPresent(x -> b.serializers().add((Class<?>)x));
            this.classes(a.parsers()).ifPresent(x -> b.parsers().add((Class<?>)x));
            this.type(a.partSerializer()).ifPresent(x -> b.partSerializer().type((Class)x));
            this.type(a.partParser()).ifPresent(x -> b.partParser().type((Class)x));
            this.stream(a.produces()).map(MediaType::of).forEach(x -> b.produces((MediaType)x));
            this.stream(a.consumes()).map(MediaType::of).forEach(x -> b.consumes((MediaType)x));
            this.stream(a.defaultRequestAttributes()).map(x -> BasicNamedAttribute.ofPair(x)).forEach(x -> b.defaultRequestAttributes((NamedAttribute)x));
            this.stream(a.defaultRequestHeaders()).map(x -> HttpHeaders.stringHeader(x)).forEach(x -> b.defaultRequestHeaders((Header)x));
            this.stream(a.defaultResponseHeaders()).map(x -> HttpHeaders.stringHeader(x)).forEach(x -> b.defaultResponseHeaders((Header)x));
            this.string(a.defaultAccept()).map(x -> HttpHeaders.accept(x)).ifPresent(x -> b.defaultRequestHeaders((Header)x));
            this.string(a.defaultContentType()).map(x -> HttpHeaders.contentType(x)).ifPresent(x -> b.defaultRequestHeaders((Header)x));
            b.responseProcessors().add(a.responseProcessors());
            b.children(a.children());
            b.restOpArgs(a.restOpArgs());
            this.classes(a.encoders()).ifPresent(x -> b.encoders().add((Class<?>)x));
            this.type(a.contextClass()).ifPresent(x -> b.type((Class)x));
            this.string(a.uriContext()).ifPresent(x -> b.uriContext((String)x));
            this.string(a.uriAuthority()).ifPresent(x -> b.uriAuthority((String)x));
            this.string(a.uriRelativity()).map(UriRelativity::valueOf).ifPresent(x -> b.uriRelativity((UriRelativity)((Object)x)));
            this.string(a.uriResolution()).map(UriResolution::valueOf).ifPresent(x -> b.uriResolution((UriResolution)((Object)x)));
            b.messages().location(this.string(a.messages()).orElse(null));
            this.type(a.fileFinder()).ifPresent(x -> b.fileFinder().type((Class)x));
            this.type(a.staticFiles()).ifPresent(x -> b.staticFiles().type((Class)x));
            this.string(a.path()).ifPresent(x -> b.path((String)x));
            this.string(a.clientVersionHeader()).ifPresent(x -> b.clientVersionHeader((String)x));
            this.type(a.callLogger()).ifPresent(x -> b.callLogger().type((Class)x));
            this.type(a.swaggerProvider()).ifPresent(x -> b.swaggerProvider((Class<? extends SwaggerProvider>)x));
            this.type(a.restOpContextClass()).ifPresent(x -> b.restOpContextClass((Class<? extends RestOpContext>)x));
            this.type(a.restChildrenClass()).ifPresent(x -> b.restChildrenClass((Class<? extends RestChildren>)x));
            this.type(a.restOperationsClass()).ifPresent(x -> b.restOperationsClass((Class<? extends RestOperations>)x));
            this.type(a.debugEnablement()).ifPresent(x -> b.debugEnablement().type((Class<? extends DebugEnablement>)x));
            this.string(a.disableContentParam()).map(Boolean::parseBoolean).ifPresent(x -> b.disableContentParam((boolean)x));
            this.string(a.allowedHeaderParams()).ifPresent(x -> b.allowedHeaderParams((String)x));
            this.string(a.allowedMethodHeaders()).ifPresent(x -> b.allowedMethodHeaders((String)x));
            this.string(a.allowedMethodParams()).ifPresent(x -> b.allowedMethodParams((String)x));
            this.bool(a.renderResponseStackTraces()).ifPresent(x -> b.renderResponseStackTraces((boolean)x));
            this.string(a.debug()).map(Enablement::fromString).ifPresent(x -> b.debug((Enablement)((Object)x)));
            this.string(a.debugOn()).ifPresent(x -> b.debugOn((String)x));
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Rest {
        private final Class<? extends RestContext.Builder> builder;
        private final Class<? extends Encoder>[] encoders;
        private final Class<? extends HttpPartParser> partParser;
        private final Class<? extends HttpPartSerializer> partSerializer;
        private final Class<? extends FileFinder> fileFinder;
        private final Class<? extends StaticFiles> staticFiles;
        private final Class<? extends ResponseProcessor>[] responseProcessors;
        private final Class<? extends RestLogger> callLogger;
        private final Class<? extends RestContext> contextClass;
        private final Class<? extends RestConverter>[] converters;
        private final Class<? extends RestGuard>[] guards;
        private final Class<? extends SwaggerProvider> swaggerProvider;
        private final Class<? extends RestOpArg>[] restOpArgs;
        private final Class<? extends BeanStore> beanStore;
        private final Class<? extends RestOpContext> restOpContextClass;
        private final Class<? extends RestChildren> restChildrenClass;
        private final Class<? extends RestOperations> restOperationsClass;
        private final Class<? extends DebugEnablement> debugEnablement;
        private final Class<? extends Serializer>[] serializers;
        private final Class<?>[] children;
        private final Class<?>[] parsers;
        private final Swagger swagger;
        private final String disableContentParam;
        private final String allowedHeaderParams;
        private final String allowedMethodHeaders;
        private final String allowedMethodParams;
        private final String clientVersionHeader;
        private final String config;
        private final String debug;
        private final String debugOn;
        private final String defaultAccept;
        private final String defaultCharset;
        private final String defaultContentType;
        private final String maxInput;
        private final String messages;
        private final String path;
        private final String renderResponseStackTraces;
        private final String roleGuard;
        private final String rolesDeclared;
        private final String siteName;
        private final String uriAuthority;
        private final String uriContext;
        private final String uriRelativity;
        private final String uriResolution;
        private final String[] consumes;
        private final String[] description;
        private final String[] produces;
        private final String[] defaultRequestAttributes;
        private final String[] defaultRequestHeaders;
        private final String[] defaultResponserHeaders;
        private final String[] title;

        Impl(Builder b) {
            super(b);
            this.builder = b.builder;
            this.disableContentParam = b.disableContentParam;
            this.allowedHeaderParams = b.allowedHeaderParams;
            this.allowedMethodHeaders = b.allowedMethodHeaders;
            this.allowedMethodParams = b.allowedMethodParams;
            this.beanStore = b.beanStore;
            this.callLogger = b.callLogger;
            this.children = ArrayUtils.copyOf(b.children);
            this.clientVersionHeader = b.clientVersionHeader;
            this.config = b.config;
            this.consumes = ArrayUtils.copyOf(b.consumes);
            this.contextClass = b.contextClass;
            this.converters = ArrayUtils.copyOf(b.converters);
            this.debug = b.debug;
            this.debugEnablement = b.debugEnablement;
            this.debugOn = b.debugOn;
            this.defaultAccept = b.defaultAccept;
            this.defaultCharset = b.defaultCharset;
            this.defaultContentType = b.defaultContentType;
            this.defaultRequestAttributes = ArrayUtils.copyOf(b.defaultRequestAttributes);
            this.defaultRequestHeaders = ArrayUtils.copyOf(b.defaultRequestHeaders);
            this.defaultResponserHeaders = ArrayUtils.copyOf(b.defaultResponseHeaders);
            this.description = ArrayUtils.copyOf(b.description);
            this.encoders = ArrayUtils.copyOf(b.encoders);
            this.fileFinder = b.fileFinder;
            this.guards = ArrayUtils.copyOf(b.guards);
            this.maxInput = b.maxInput;
            this.messages = b.messages;
            this.parsers = ArrayUtils.copyOf(b.parsers);
            this.partParser = b.partParser;
            this.partSerializer = b.partSerializer;
            this.path = b.path;
            this.produces = ArrayUtils.copyOf(b.produces);
            this.renderResponseStackTraces = b.renderResponseStackTraces;
            this.responseProcessors = ArrayUtils.copyOf(b.responseProcessors);
            this.restChildrenClass = b.restChildrenClass;
            this.restOpContextClass = b.restOpContextClass;
            this.restOperationsClass = b.restOperationsClass;
            this.restOpArgs = ArrayUtils.copyOf(b.restOpArgs);
            this.roleGuard = b.roleGuard;
            this.rolesDeclared = b.rolesDeclared;
            this.serializers = ArrayUtils.copyOf(b.serializers);
            this.siteName = b.siteName;
            this.staticFiles = b.staticFiles;
            this.swagger = b.swagger;
            this.swaggerProvider = b.swaggerProvider;
            this.title = ArrayUtils.copyOf(b.title);
            this.uriAuthority = b.uriAuthority;
            this.uriContext = b.uriContext;
            this.uriRelativity = b.uriRelativity;
            this.uriResolution = b.uriResolution;
            this.postConstruct();
        }

        @Override
        public Class<? extends RestContext.Builder> builder() {
            return this.builder;
        }

        @Override
        public String disableContentParam() {
            return this.disableContentParam;
        }

        @Override
        public String allowedHeaderParams() {
            return this.allowedHeaderParams;
        }

        @Override
        public String allowedMethodHeaders() {
            return this.allowedMethodHeaders;
        }

        @Override
        public String allowedMethodParams() {
            return this.allowedMethodParams;
        }

        @Override
        public Class<? extends BeanStore> beanStore() {
            return this.beanStore;
        }

        @Override
        public Class<? extends RestLogger> callLogger() {
            return this.callLogger;
        }

        @Override
        public Class<?>[] children() {
            return this.children;
        }

        @Override
        public String clientVersionHeader() {
            return this.clientVersionHeader;
        }

        @Override
        public String config() {
            return this.config;
        }

        @Override
        public String[] consumes() {
            return this.consumes;
        }

        @Override
        public Class<? extends RestContext> contextClass() {
            return this.contextClass;
        }

        @Override
        public Class<? extends RestConverter>[] converters() {
            return this.converters;
        }

        @Override
        public String debug() {
            return this.debug;
        }

        @Override
        public Class<? extends DebugEnablement> debugEnablement() {
            return this.debugEnablement;
        }

        @Override
        public String debugOn() {
            return this.debugOn;
        }

        @Override
        public String defaultAccept() {
            return this.defaultAccept;
        }

        @Override
        public String defaultCharset() {
            return this.defaultCharset;
        }

        @Override
        public String defaultContentType() {
            return this.defaultContentType;
        }

        @Override
        public String[] defaultRequestAttributes() {
            return this.defaultRequestAttributes;
        }

        @Override
        public String[] defaultRequestHeaders() {
            return this.defaultRequestHeaders;
        }

        @Override
        public String[] defaultResponseHeaders() {
            return this.defaultResponserHeaders;
        }

        @Override
        public String[] description() {
            return this.description;
        }

        @Override
        public Class<? extends Encoder>[] encoders() {
            return this.encoders;
        }

        @Override
        public Class<? extends FileFinder> fileFinder() {
            return this.fileFinder;
        }

        @Override
        public Class<? extends RestGuard>[] guards() {
            return this.guards;
        }

        @Override
        public String maxInput() {
            return this.maxInput;
        }

        @Override
        public String messages() {
            return this.messages;
        }

        @Override
        public Class<?>[] parsers() {
            return this.parsers;
        }

        @Override
        public Class<? extends HttpPartParser> partParser() {
            return this.partParser;
        }

        @Override
        public Class<? extends HttpPartSerializer> partSerializer() {
            return this.partSerializer;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        public String[] produces() {
            return this.produces;
        }

        @Override
        public String renderResponseStackTraces() {
            return this.renderResponseStackTraces;
        }

        @Override
        public Class<? extends ResponseProcessor>[] responseProcessors() {
            return this.responseProcessors;
        }

        @Override
        public Class<? extends RestChildren> restChildrenClass() {
            return this.restChildrenClass;
        }

        @Override
        public Class<? extends RestOpContext> restOpContextClass() {
            return this.restOpContextClass;
        }

        @Override
        public Class<? extends RestOpArg>[] restOpArgs() {
            return this.restOpArgs;
        }

        @Override
        public Class<? extends RestOperations> restOperationsClass() {
            return this.restOperationsClass;
        }

        @Override
        public String roleGuard() {
            return this.roleGuard;
        }

        @Override
        public String rolesDeclared() {
            return this.rolesDeclared;
        }

        @Override
        public Class<? extends Serializer>[] serializers() {
            return this.serializers;
        }

        @Override
        public String siteName() {
            return this.siteName;
        }

        @Override
        public Class<? extends StaticFiles> staticFiles() {
            return this.staticFiles;
        }

        @Override
        public Swagger swagger() {
            return this.swagger;
        }

        @Override
        public Class<? extends SwaggerProvider> swaggerProvider() {
            return this.swaggerProvider;
        }

        @Override
        public String[] title() {
            return this.title;
        }

        @Override
        public String uriAuthority() {
            return this.uriAuthority;
        }

        @Override
        public String uriContext() {
            return this.uriContext;
        }

        @Override
        public String uriRelativity() {
            return this.uriRelativity;
        }

        @Override
        public String uriResolution() {
            return this.uriResolution;
        }
    }

    public static class Builder
    extends TargetedAnnotationTBuilder {
        Class<? extends RestContext.Builder> builder = RestContext.Builder.Void.class;
        Class<? extends Encoder>[] encoders = new Class[0];
        Class<? extends HttpPartParser> partParser = HttpPartParser.Void.class;
        Class<? extends HttpPartSerializer> partSerializer = HttpPartSerializer.Void.class;
        Class<? extends FileFinder> fileFinder = FileFinder.Void.class;
        Class<? extends StaticFiles> staticFiles = StaticFiles.Void.class;
        Class<? extends ResponseProcessor>[] responseProcessors = new Class[0];
        Class<? extends RestLogger> callLogger = RestLogger.Void.class;
        Class<? extends RestContext> contextClass = RestContext.Void.class;
        Class<? extends RestConverter>[] converters = new Class[0];
        Class<? extends RestGuard>[] guards = new Class[0];
        Class<? extends SwaggerProvider> swaggerProvider = SwaggerProvider.Void.class;
        Class<? extends RestOpArg>[] restOpArgs = new Class[0];
        Class<? extends BeanStore> beanStore = BeanStore.Void.class;
        Class<? extends RestOpContext> restOpContextClass = RestOpContext.Void.class;
        Class<? extends RestChildren> restChildrenClass = RestChildren.Void.class;
        Class<? extends RestOperations> restOperationsClass = RestOperations.Void.class;
        Class<? extends DebugEnablement> debugEnablement = DebugEnablement.Void.class;
        Class<? extends Serializer>[] serializers = new Class[0];
        Class<?>[] children = new Class[0];
        Class<?>[] parsers = new Class[0];
        Swagger swagger = SwaggerAnnotation.DEFAULT;
        String disableContentParam = "";
        String allowedHeaderParams = "";
        String allowedMethodHeaders = "";
        String allowedMethodParams = "";
        String clientVersionHeader = "";
        String config = "";
        String debug = "";
        String debugOn = "";
        String defaultAccept = "";
        String defaultCharset = "";
        String defaultContentType = "";
        String maxInput = "";
        String messages = "";
        String path = "";
        String renderResponseStackTraces = "";
        String roleGuard = "";
        String rolesDeclared = "";
        String siteName = "";
        String uriAuthority = "";
        String uriContext = "";
        String uriRelativity = "";
        String uriResolution = "";
        String[] consumes = new String[0];
        String[] defaultRequestAttributes = new String[0];
        String[] defaultRequestHeaders = new String[0];
        String[] defaultResponseHeaders = new String[0];
        String[] description = new String[0];
        String[] produces = new String[0];
        String[] title = new String[0];

        protected Builder() {
            super(Rest.class);
        }

        public Rest build() {
            return new Impl(this);
        }

        public Builder disableContentParam(String value) {
            this.disableContentParam = value;
            return this;
        }

        public Builder allowedHeaderParams(String value) {
            this.allowedHeaderParams = value;
            return this;
        }

        public Builder allowedMethodHeaders(String value) {
            this.allowedMethodHeaders = value;
            return this;
        }

        public Builder allowedMethodParams(String value) {
            this.allowedMethodParams = value;
            return this;
        }

        public Builder beanStore(Class<? extends BeanStore> value) {
            this.beanStore = value;
            return this;
        }

        public Builder callLogger(Class<? extends RestLogger> value) {
            this.callLogger = value;
            return this;
        }

        public Builder children(Class<?> ... value) {
            this.children = value;
            return this;
        }

        public Builder clientVersionHeader(String value) {
            this.clientVersionHeader = value;
            return this;
        }

        public Builder config(String value) {
            this.config = value;
            return this;
        }

        public Builder consumes(String ... value) {
            this.consumes = value;
            return this;
        }

        public Builder contextClass(Class<? extends RestContext> value) {
            this.contextClass = value;
            return this;
        }

        public Builder converters(Class<? extends RestConverter> ... value) {
            this.converters = value;
            return this;
        }

        public Builder debug(String value) {
            this.debug = value;
            return this;
        }

        public Builder debugEnablement(Class<? extends DebugEnablement> value) {
            this.debugEnablement = value;
            return this;
        }

        public Builder debugOn(String value) {
            this.debugOn = value;
            return this;
        }

        public Builder defaultAccept(String value) {
            this.defaultAccept = value;
            return this;
        }

        public Builder defaultCharset(String value) {
            this.defaultCharset = value;
            return this;
        }

        public Builder defaultContentType(String value) {
            this.defaultContentType = value;
            return this;
        }

        public Builder defaultRequestAttributes(String ... value) {
            this.defaultRequestAttributes = value;
            return this;
        }

        public Builder defaultRequestHeaders(String ... value) {
            this.defaultRequestHeaders = value;
            return this;
        }

        public Builder defaultResponseHeaders(String ... value) {
            this.defaultResponseHeaders = value;
            return this;
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder encoders(Class<? extends Encoder> ... value) {
            this.encoders = value;
            return this;
        }

        public Builder fileFinder(Class<? extends FileFinder> value) {
            this.fileFinder = value;
            return this;
        }

        public Builder guards(Class<? extends RestGuard> ... value) {
            this.guards = value;
            return this;
        }

        public Builder maxInput(String value) {
            this.maxInput = value;
            return this;
        }

        public Builder messages(String value) {
            this.messages = value;
            return this;
        }

        public Builder parsers(Class<?> ... value) {
            this.parsers = value;
            return this;
        }

        public Builder partParser(Class<? extends HttpPartParser> value) {
            this.partParser = value;
            return this;
        }

        public Builder partSerializer(Class<? extends HttpPartSerializer> value) {
            this.partSerializer = value;
            return this;
        }

        public Builder path(String value) {
            this.path = value;
            return this;
        }

        public Builder produces(String ... value) {
            this.produces = value;
            return this;
        }

        public Builder renderResponseStackTraces(String value) {
            this.renderResponseStackTraces = value;
            return this;
        }

        public Builder responseProcessors(Class<? extends ResponseProcessor> ... value) {
            this.responseProcessors = value;
            return this;
        }

        public Builder restChildrenClass(Class<? extends RestChildren> value) {
            this.restChildrenClass = value;
            return this;
        }

        public Builder restOpContextClass(Class<? extends RestOpContext> value) {
            this.restOpContextClass = value;
            return this;
        }

        public Builder restOpArgs(Class<? extends RestOpArg> ... value) {
            this.restOpArgs = value;
            return this;
        }

        public Builder restOperationsClass(Class<? extends RestOperations> value) {
            this.restOperationsClass = value;
            return this;
        }

        public Builder roleGuard(String value) {
            this.roleGuard = value;
            return this;
        }

        public Builder rolesDeclared(String value) {
            this.rolesDeclared = value;
            return this;
        }

        public Builder serializers(Class<? extends Serializer> ... value) {
            this.serializers = value;
            return this;
        }

        public Builder siteName(String value) {
            this.siteName = value;
            return this;
        }

        public Builder staticFiles(Class<? extends StaticFiles> value) {
            this.staticFiles = value;
            return this;
        }

        public Builder swagger(Swagger value) {
            this.swagger = value;
            return this;
        }

        public Builder swaggerProvider(Class<? extends SwaggerProvider> value) {
            this.swaggerProvider = value;
            return this;
        }

        public Builder title(String ... value) {
            this.title = value;
            return this;
        }

        public Builder uriAuthority(String value) {
            this.uriAuthority = value;
            return this;
        }

        public Builder uriContext(String value) {
            this.uriContext = value;
            return this;
        }

        public Builder uriRelativity(String value) {
            this.uriRelativity = value;
            return this;
        }

        public Builder uriResolution(String value) {
            this.uriResolution = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass(value);
            return this;
        }
    }
}

