/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.Optional;
import java.util.function.Consumer;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.Context;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ThrowableUtils;

public class ContextBeanCreator<T> {
    private Class<T> type;
    private T impl;
    private Context.Builder builder;

    public static <T> ContextBeanCreator<T> create(Class<T> type) {
        return new ContextBeanCreator<T>(type);
    }

    protected ContextBeanCreator(Class<T> type) {
        this.type = type;
    }

    protected ContextBeanCreator(ContextBeanCreator<T> copyFrom) {
        this.type = copyFrom.type;
        this.impl = copyFrom.impl;
        this.builder = copyFrom.builder == null ? null : copyFrom.builder.copy();
    }

    public ContextBeanCreator<T> impl(Object value) {
        this.impl = value;
        return this;
    }

    public ContextBeanCreator<T> type(Class<? extends T> value) {
        this.builder = Context.createBuilder(value);
        if (this.builder == null) {
            throw ThrowableUtils.runtimeException("Creator for class {0} not found." + value.getName(), new Object[0]);
        }
        return this;
    }

    public <B extends Context.Builder> Optional<B> builder(Class<B> c) {
        return CollectionUtils.optional(c.isInstance(this.builder) ? (Context.Builder)c.cast(this.builder) : null);
    }

    public <B extends Context.Builder> ContextBeanCreator<T> builder(Class<B> c, Consumer<B> operation) {
        if (c.isInstance(this.builder)) {
            operation.accept(c.cast(this.builder));
        }
        return this;
    }

    public boolean canApply(AnnotationWorkList work) {
        if (this.builder != null) {
            return this.builder.canApply(work);
        }
        return false;
    }

    public ContextBeanCreator<T> apply(AnnotationWorkList work) {
        if (this.builder != null) {
            this.builder.apply(work);
        }
        return this;
    }

    public ContextBeanCreator<T> copy() {
        return new ContextBeanCreator<T>(this);
    }

    public T create() {
        if (this.impl != null) {
            return this.impl;
        }
        if (this.builder != null) {
            return (T)this.builder.build();
        }
        return null;
    }
}

